<form method="post" class="ajax-submit" autocomplete="off" action="<?php echo e(route('bank_transactions.store')); ?>" enctype="multipart/form-data">
	<?php echo csrf_field(); ?>
	<div class="row px-2">
	    <div class="col-lg-6">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Trans Date')); ?></label>						
				<input type="text" class="form-control datepicker" name="trans_date" value="<?php echo e(old('trans_date')); ?>" required>
			</div>
		</div>

		<div class="col-lg-6">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Bank Account')); ?></label>						
				<select class="form-control auto-select" data-selected="<?php echo e(old('bank_account_id')); ?>" name="bank_account_id"  required>
					<option value=""><?php echo e(_lang('Select One')); ?></option>
					<?php $__currentLoopData = App\Models\BankAccount::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<option value="<?php echo e($account->id); ?>"><?php echo e($account->bank_name); ?> (<?php echo e($account->account_name); ?> - <?php echo e($account->currency->name); ?>)</option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</select>
			</div>
		</div>

		<div class="col-lg-12">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Amount')); ?></label>						
				<input type="text" class="form-control float-field" name="amount" value="<?php echo e(old('amount')); ?>" required>
			</div>
		</div>

		<div class="col-lg-12">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Type')); ?></label>						
				<select class="form-control auto-select" data-selected="<?php echo e(old('type', 'cash_to_bank')); ?>" id="type" name="type"  required>
					<option value="cash_to_bank"><?php echo e(_lang('Cash to Bank')); ?></option>
					<option value="bank_to_cash"><?php echo e(_lang('Bank to Cash')); ?></option>
					<option value="deposit"><?php echo e(_lang('Despoit')); ?></option>
					<option value="withdraw"><?php echo e(_lang('Withdraw')); ?></option>
				</select>
			</div>
		</div>

		<div class="col-lg-12 <?php echo e(old('type', 'deposit') != 'withdraw' ? 'd-none' : ''); ?>" id="cheque_number">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Cheque Number')); ?></label>						
				<input type="text" class="form-control" name="cheque_number" value="<?php echo e(old('cheque_number')); ?>">
			</div>
		</div>

		<div class="col-lg-12">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Attachment')); ?></label>						
				<input type="file" class="form-control dropify" name="attachment" data-allowed-file-extensions="png jpg jpeg PNG JPG JPEG">
			</div>
		</div>

		<div class="col-lg-12">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Description')); ?></label>						
				<textarea class="form-control" name="description" value="<?php echo e(old('description')); ?>"></textarea>
			</div>
		</div>

		<div class="col-lg-12">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Status')); ?></label>						
				<select class="form-control auto-select" data-selected="<?php echo e(old('status', 1)); ?>" name="status" required>
					<option value="1"><?php echo e(_lang('Completed')); ?></option>
					<option value="0"><?php echo e(_lang('Pending')); ?></option>
				</select>
			</div>
		</div>
	
		<div class="col-lg-12 mt-2">
		    <div class="form-group">
			    <button type="submit" class="btn btn-primary"><i class="ti-check-box mr-2"></i> <?php echo e(_lang('Save')); ?></button>
		    </div>
		</div>
	</div>
</form>

<script>
	$(document).on('change', '#type', function(){
		if($(this).val() != 'withdraw'){
			$("#cheque_number").addClass('d-none');
		}else{
			$("#cheque_number").removeClass('d-none');
		}
	});
</script><?php /**PATH /home2/itmihost/public_html/fsbms.forgedcloud.com/resources/views/backend/admin/bank_transaction/modal/create.blade.php ENDPATH**/ ?>