

<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-12">
		<div class="card">
			<div class="card-header">
				<span class="panel-title"><?php echo e(_lang('Update Loan Information')); ?></span>
			</div>
			<div class="card-body">
				<?php if($loan->status == 1): ?>
					<div class="alert alert-warning">
						<strong><?php echo e(_lang('Loan has already approved. You can change only description and remarks')); ?></strong>
					</div>
				<?php endif; ?>
				<form method="post" class="validate" autocomplete="off" action="<?php echo e(route('loans.update', $id)); ?>" enctype="multipart/form-data">
					<?php echo csrf_field(); ?>
					<input name="_method" type="hidden" value="PATCH">
					<div class="row">
						<div class="col-lg-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Loan Product')); ?></label>
								<select class="form-control auto-select select2" data-selected="<?php echo e($loan->loan_product_id); ?>" id="loan_product_id" name="loan_product_id" <?php echo e($loan->status == 1 ? 'disabled' : 'required'); ?>>
									<option value=""><?php echo e(_lang('Select One')); ?></option>
									<?php $__currentLoopData = \App\Models\LoanProduct::active()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loanProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($loanProduct->id); ?>" data-penalties="<?php echo e($loanProduct->late_payment_penalties); ?>"><?php echo e($loanProduct->name); ?></option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</select>
							</div>
						</div>

						<div class="col-lg-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Loan ID')); ?></label>
								<input type="text" class="form-control" name="loan_id" value="<?php echo e($loan->loan_id); ?>" <?php echo e($loan->status == 1 ? 'disabled' : 'required'); ?>>
							</div>
						</div>

						<div class="col-lg-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Borrower')); ?></label>
								<select class="form-control auto-select select2" data-selected="<?php echo e($loan->borrower_id); ?>" name="borrower_id" id="borrower_id" <?php echo e($loan->status == 1 ? 'disabled' : 'required'); ?>>
									<option value=""><?php echo e(_lang('Select One')); ?></option>
									<?php $__currentLoopData = \App\Models\Member::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<option value="<?php echo e($member->id); ?>"><?php echo e($member->first_name.' '.$member->last_name .' ('. $member->member_no . ')'); ?></option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</select>
							</div>
						</div>

						<div class="col-lg-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Currency')); ?></label>
								<select class="form-control auto-select" data-selected="<?php echo e($loan->currency_id); ?>" name="currency_id" <?php echo e($loan->status == 1 ? 'disabled' : 'required'); ?>>
									<option value=""><?php echo e(_lang('Select One')); ?></option>
									<?php $__currentLoopData = \App\Models\Currency::where('status', 1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($currency->id); ?>"><?php echo e($currency->full_name); ?> (<?php echo e($currency->name); ?>)</option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</select>
							</div>
						</div>

							<div class="col-lg-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('First Payment Date')); ?></label>
								<input type="text" class="form-control datepicker" name="first_payment_date" value="<?php echo e($loan->getRawOriginal('first_payment_date')); ?>" <?php echo e($loan->status == 1 ? 'disabled' : 'required'); ?>>
							</div>
						</div>

						<div class="col-lg-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Release Date')); ?></label>
								<input type="text" class="form-control datepicker" name="release_date" value="<?php echo e($loan->getRawOriginal('release_date')); ?>" <?php echo e($loan->status == 1 ? 'disabled' : 'required'); ?>>
							</div>
						</div>

						<div class="col-lg-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Applied Amount')); ?></label>
								<input type="text" class="form-control float-field" name="applied_amount" value="<?php echo e($loan->applied_amount); ?>" <?php echo e($loan->status == 1 ? 'disabled' : 'required'); ?>>
							</div>
						</div>

						<div class="col-lg-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Late Payment Penalties')); ?></label>
								<div class="input-group">
									<input type="text" class="form-control float-field" name="late_payment_penalties" value="<?php echo e($loan->late_payment_penalties); ?>" id="late_payment_penalties" <?php echo e($loan->status == 1 ? 'disabled' : 'required'); ?>>
									<div class="input-group-append">
										<span class="input-group-text">%</span>
									</div>
								</div>
							</div>
						</div>

						<!--Custom Fields-->
						<?php if(! $customFields->isEmpty()): ?>
							<?php $customFieldsData = json_decode($loan->custom_fields, true); ?>
							<?php $__currentLoopData = $customFields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customField): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<div class="<?php echo e($customField->field_width); ?>">
								<div class="form-group">
									<label class="control-label">
										<?php echo e($customField->field_name); ?>

									</label>
									<?php echo xss_clean(generate_input_field($customField, $customFieldsData[$customField->field_name]['field_value'] ?? null)); ?>

								</div>
							</div>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>

						<div class="col-lg-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Fee Deduct Account')); ?></label>
								<select class="form-control auto-select select2" data-selected="<?php echo e($loan->debit_account_id); ?>" name="debit_account_id" id="debit_account" required>
									<option value=""><?php echo e(_lang('Select One')); ?></option>
									<?php $__currentLoopData = \App\Models\SavingsAccount::where('member_id', $loan->borrower_id)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($account->id); ?>"><?php echo e($account->account_number); ?> (<?php echo e($account->savings_type->name.' - '.$account->savings_type->currency->name); ?>)</option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</select>
							</div>
						</div>

						<div class="col-md-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Attachment')); ?></label>
								<input type="file" class="dropify" name="attachment" data-default-file="<?php echo e($loan->attachment != null ? asset('public/uploads/media/'.$loan->attachment) : ''); ?>"  <?php echo e($loan->status == 1 ? 'disabled' : ''); ?>>
							</div>
						</div>

						<div class="col-md-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Description')); ?></label>
								<textarea class="form-control" name="description"><?php echo e($loan->description); ?></textarea>
							</div>
						</div>

						<div class="col-md-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Remarks')); ?></label>
								<textarea class="form-control" name="remarks"><?php echo e($loan->remarks); ?></textarea>
							</div>
						</div>

						<div class="col-md-12 mt-2">
							<div class="form-group">
								<button type="submit" class="btn btn-primary"><?php echo e(_lang('Update Changes')); ?></button>
							</div>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
(function ($) {

	$(document).on('change', '#loan_product_id', function(){
		$("#late_payment_penalties").val($(this).find(':selected').data('penalties'));
	});

	$(document).on('change','#borrower_id',function(){
		var member_id = $(this).val();
		if(member_id != ''){
			$.ajax({
				url: _tenant_url + '/savings_accounts/get_account_by_member_id/' + member_id,
				success: function(data){
					var json = JSON.parse(JSON.stringify(data));
					$("#debit_account").html('');
					$.each(json['accounts'], function(i, account) {
						$("#debit_account").append(`<option value="${account.id}">${account.account_number} (${account.savings_type.name} - ${account.savings_type.currency.name})</option>`);
					});

				}
			});
		}
	});

})(jQuery);
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home2/itmihost/public_html/fsbms.forgedcloud.com/resources/views/backend/admin/loan/edit.blade.php ENDPATH**/ ?>