<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-12">
		<div class="card">
			<div class="card-header">
				<span class="panel-title"><?php echo e(_lang('Loan Due Report')); ?></span>
			</div>

			<div class="card-body">

				<?php $date_format = get_date_format(); ?>
				<?php $currency = currency(); ?>

				<div class="report-header">
				   <img src="<?php echo e(get_logo()); ?>" class="logo"/>
				   <h4><?php echo e(_lang('Loan Due Report')); ?></h4>
				   <h5><?php echo e(_lang('Date').': '. date($date_format)); ?></h5>
				</div>

				<table class="table table-bordered report-table">
					<thead>
						<th><?php echo e(_lang('Loan ID')); ?></th>
						<th><?php echo e(_lang('Member No')); ?></th>
						<th><?php echo e(_lang('Member')); ?></th>
						<th class="text-right"><?php echo e(_lang('Total Due Amount')); ?></th>
					</thead>
					<tbody>
					<?php if(isset($report_data)): ?>
						<?php $__currentLoopData = $report_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $repayment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<tr>
								<td><a href="<?php echo e(route('loans.show', $repayment->loan_id)); ?>" target="_blank"><?php echo e($repayment->loan->loan_id); ?></a></td>
								<td><a href="<?php echo e(route('members.show', $repayment->loan->borrower_id)); ?>" target="_blank"><?php echo e($repayment->loan->borrower->member_no); ?></a></td>
								<td><?php echo e($repayment->loan->borrower->name); ?></td>
								<td class="text-right"><?php echo e(decimalPlace($repayment->total_due, currency($repayment->loan->currency->name))); ?></td>						
							</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					<?php endif; ?>
				    </tbody>
				</table>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home2/itmihost/public_html/fsbms.forgedcloud.com/resources/views/backend/admin/reports/loan_due_report.blade.php ENDPATH**/ ?>