<?php $__env->startSection('content'); ?>

<div class="row">
	<div class="col-lg-12">
		<div class="card no-export">
		    <div class="card-header d-flex align-items-center">
				<span class="panel-title"><?php echo e(_lang('Transaction Categories')); ?></span>
				<a class="btn btn-primary btn-xs ml-auto ajax-modal" data-title="<?php echo e(_lang('New Category')); ?>" href="<?php echo e(route('transaction_categories.create')); ?>"><i class="ti-plus"></i>&nbsp;<?php echo e(_lang('Add New')); ?></a>
			</div>
			<div class="card-body">
				<table id="transaction_categories_table" class="table table-bordered data-table">
					<thead>
					    <tr>
						    <th><?php echo e(_lang('Name')); ?></th>
							<th><?php echo e(_lang('Related To')); ?></th>
							<th><?php echo e(_lang('Status')); ?></th>
							<th class="text-center"><?php echo e(_lang('Action')); ?></th>
					    </tr>
					</thead>
					<tbody>
						<tr>
							<td class='name'><?php echo e(_lang('Deposit')); ?></td>
							<td class='related_to'><?php echo e(_lang('Credit')); ?></td>
							<td class='status'><?php echo xss_clean(status(1)); ?></td>
							<td class="text-center"><button class="btn btn-primary btn-xs disabled"><?php echo e(_lang('No Action')); ?></button></td>		
						</tr>
						<tr>
							<td class='name'><?php echo e(_lang('Withdraw')); ?></td>
							<td class='related_to'><?php echo e(_lang('Debit')); ?></td>
							<td class='status'><?php echo xss_clean(status(1)); ?></td>
							<td class="text-center"><button class="btn btn-primary btn-xs disabled"><?php echo e(_lang('No Action')); ?></button></td>		
						</tr>
						<tr>
							<td class='name'><?php echo e(_lang('Account Maintenance Fee')); ?></td>
							<td class='related_to'><?php echo e(_lang('Debit')); ?></td>
							<td class='status'><?php echo xss_clean(status(1)); ?></td>
							<td class="text-center"><button class="btn btn-primary btn-xs disabled"><?php echo e(_lang('No Action')); ?></button></td>		
						</tr>
					    <?php $__currentLoopData = $transactioncategorys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transactioncategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					    <tr data-id="row_<?php echo e($transactioncategory->id); ?>">
							<td class='name'><?php echo e($transactioncategory->name); ?></td>
							<td class='related_to'><?php echo e($transactioncategory->related_to == 'dr' ? _lang('Debit') : _lang('Credit')); ?></td>
							<td class='status'><?php echo xss_clean(status($transactioncategory->status)); ?></td>
							
							<td class="text-center">
								<span class="dropdown">
								  <button class="btn btn-primary dropdown-toggle btn-xs" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								  <?php echo e(_lang('Action')); ?>

								  </button>
								  <form action="<?php echo e(route('transaction_categories.destroy', $transactioncategory['id'])); ?>" method="post">
									<?php echo csrf_field(); ?>
									<input name="_method" type="hidden" value="DELETE">

									<div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
										<a href="<?php echo e(route('transaction_categories.edit', $transactioncategory['id'])); ?>" data-title="<?php echo e(_lang('Update Category')); ?>" class="dropdown-item dropdown-edit ajax-modal"><i class="ti-pencil-alt"></i>&nbsp;<?php echo e(_lang('Edit')); ?></a>
										<a href="<?php echo e(route('transaction_categories.show', $transactioncategory['id'])); ?>" data-title="<?php echo e(_lang('Category Details')); ?>" class="dropdown-item dropdown-view ajax-modal"><i class="ti-eye"></i>&nbsp;<?php echo e(_lang('View')); ?></a>
										<button class="btn-remove dropdown-item" type="submit"><i class="ti-trash"></i>&nbsp;<?php echo e(_lang('Delete')); ?></button>
									</div>
								  </form>
								</span>
							</td>
					    </tr>
					    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home2/itmihost/public_html/fsbms.forgedcloud.com/resources/views/backend/admin/transaction_category/list.blade.php ENDPATH**/ ?>