<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-12">
		<div class="card">
			<div class="card-header">
				<span class="panel-title"><?php echo e(_lang('Loan Report')); ?></span>
			</div>

			<div class="card-body">

				<div class="report-params">
					<form class="validate" method="post" action="<?php echo e(route('reports.loan_report')); ?>">
						<div class="row">
              				<?php echo csrf_field(); ?>

							<div class="col-xl-2 col-lg-4">
								<div class="form-group">
									<label class="control-label"><?php echo e(_lang('Start Date')); ?></label>
									<input type="text" class="form-control datepicker" name="date1" id="date1" value="<?php echo e(isset($date1) ? $date1 : old('date1')); ?>" readOnly="true" required>
								</div>
							</div>

							<div class="col-xl-2 col-lg-4">
								<div class="form-group">
									<label class="control-label"><?php echo e(_lang('End Date')); ?></label>
									<input type="text" class="form-control datepicker" name="date2" id="date2" value="<?php echo e(isset($date2) ? $date2 : old('date2')); ?>" readOnly="true" required>
								</div>
							</div>

							<div class="col-xl-2 col-lg-4">
								<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Loan Type')); ?></label>
									<select class="form-control auto-select" data-selected="<?php echo e(isset($loan_type) ? $loan_type : old('loan_type')); ?>" name="loan_type">
										<option value=""><?php echo e(_lang('All')); ?></option>
										<?php $__currentLoopData = \App\Models\LoanProduct::where('status', 1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<option value="<?php echo e($loan_product->id); ?>"><?php echo e($loan_product->name); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
								</div>
							</div>

                            <div class="col-xl-2 col-lg-4">
								<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Status')); ?></label>
									<select class="form-control auto-select" data-selected="<?php echo e(isset($status) ? $status : old('status')); ?>" name="status">
										<option value=""><?php echo e(_lang('All')); ?></option>
										<option value="0"><?php echo e(_lang('Pending')); ?></option>
										<option value="1"><?php echo e(_lang('Approved')); ?></option>
										<option value="2"><?php echo e(_lang('Completed')); ?></option>
										<option value="3"><?php echo e(_lang('Cancelled')); ?></option>
									</select>
								</div>
							</div>

							<div class="col-xl-2 col-lg-4">
								<div class="form-group">
									<label class="control-label"><?php echo e(_lang('Member No')); ?></label>
									<input type="text" class="form-control" name="member_no" value="<?php echo e(isset($member_no) ? $member_no : old('member_no')); ?>">
								</div>
							</div>

							<div class="col-xl-2 col-lg-4">
								<button type="submit" class="btn btn-light btn-xs btn-block mt-26"><i class="ti-filter"></i>&nbsp;<?php echo e(_lang('Filter')); ?></button>
							</div>
						</form>

					</div>
				</div><!--End Report param-->

				<?php $date_format = get_date_format(); ?>
				<?php $currency = currency(); ?>

				<div class="report-header">
				   <img src="<?php echo e(get_logo()); ?>" class="logo"/>
				   <h4><?php echo e(_lang('Loan Report')); ?></h4>
				   <h5><?php echo e(isset($date1) ? date($date_format, strtotime($date1)).' '._lang('to').' '.date($date_format, strtotime($date2)) : '----------  '._lang('to').'  ----------'); ?></h5>
				</div>

				<table class="table table-bordered report-table">
					<thead>
						<th><?php echo e(_lang('Loan ID')); ?></th>
						<th><?php echo e(_lang('Member No')); ?></th>
						<th><?php echo e(_lang('Created')); ?></th>
						<th><?php echo e(_lang('Loan Product')); ?></th>
						<th><?php echo e(_lang('Borrower')); ?></th>
						<th class="text-right"><?php echo e(_lang('Applied Amount')); ?></th>
						<th class="text-right"><?php echo e(_lang('Due Amount')); ?></th>
						<th><?php echo e(_lang('Status')); ?></th>
						<th class="text-center"><?php echo e(_lang('Details')); ?></th>
					</thead>
					<tbody>
					<?php if(isset($report_data)): ?>
						<?php $__currentLoopData = $report_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<tr>
								<td><?php echo e($loan->loan_id); ?></td>
								<td><?php echo e($loan->borrower->member_no); ?></td>
								<td><?php echo e($loan->created_at); ?></td>
								<td><?php echo e($loan->loan_product->name); ?></td>
								<td><?php echo e($loan->borrower->name); ?><br><?php echo e($loan->borrower->email); ?></td>
								<td class="text-right"><?php echo e(decimalPlace($loan->applied_amount, currency($loan->currency->name))); ?></td>
								<td class="text-right"><?php echo e(decimalPlace($loan->applied_amount - $loan->total_paid, currency($loan->currency->name))); ?></td>
								<td>
									<?php if($loan->status == 0): ?>
										<?php echo xss_clean(show_status(_lang('Pending'), 'warning')); ?>

									<?php elseif($loan->status == 1): ?>
										<?php echo xss_clean(show_status(_lang('Approved'), 'success')); ?>

									<?php elseif($loan->status == 2): ?>
										<?php echo xss_clean(show_status(_lang('Completed'), 'info')); ?>

									<?php elseif($loan->status == 3): ?>
										<?php echo xss_clean(show_status(_lang('Cancelled'), 'danger')); ?>

									<?php endif; ?>
								</td>
								<td class="text-center"><a href="<?php echo e(route('loans.show', $loan->id)); ?>" target="_blank" class="btn btn-outline-primary btn-xs"><?php echo e(_lang('View')); ?></a></td>
							</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					<?php endif; ?>
				    </tbody>
				</table>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home2/itmihost/public_html/fsbms.forgedcloud.com/resources/views/backend/admin/reports/loan_report.blade.php ENDPATH**/ ?>