<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-12">
		<div class="card">
			<div class="card-header">
				<span class="panel-title"><?php echo e(_lang('Account Balances')); ?></span>
			</div>

			<div class="card-body">
				<div class="report-params">
					<form class="validate" method="post" action="<?php echo e(route('reports.account_balances')); ?>" autocomplete="off">
						<div class="row">
              				<?php echo csrf_field(); ?>

							<div class="col-xl-3 col-lg-4">
								<div class="form-group">
									<label class="control-label"><?php echo e(_lang('Account Type')); ?></label>
									<select class="form-control auto-select" name="account_type_id" data-selected="<?php echo e(isset($account_type_id) ? $account_type_id : old('account_type_id')); ?>" required>
										<option value=""><?php echo e(_lang('Select One')); ?></option>
										<?php $__currentLoopData = \App\Models\SavingsProduct::with('currency')->active()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $savings_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<option value="<?php echo e($savings_product->id); ?>"><?php echo e($savings_product->name); ?> (<?php echo e($savings_product->currency->name); ?>)</option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										<option value="all"><?php echo e(_lang('All Account Type')); ?></option>
									</select>
								</div>
							</div>

							<div class="col-xl-3 col-lg-4">
								<div class="form-group">
									<label class="control-label"><?php echo e(_lang('Member')); ?></label>
									<select class="form-control select2-ajax" data-table="members" data-value="id" data-display="first_name" data-display2="last_name" 
										name="member_id" data-where="3" data-placeholder="<?php echo e(_lang('All Member')); ?>">
										<?php if(isset($member_id) && $member_id != ''): ?>
											<option value="<?php echo e($member_id); ?>"><?php echo e(\App\Models\Member::find($member_id)->name ?? _lang('All Member')); ?></option>
										<?php endif; ?>
									</select>
								</div>
							</div>

							<div class="col-xl-2 col-lg-4">
								<button type="submit" class="btn btn-light btn-xs btn-block mt-26"><i class="ti-filter"></i>&nbsp;<?php echo e(_lang('Filter')); ?></button>
							</div>
						</form>

					</div>
				</div><!--End Report param-->

				<?php $date_format = get_date_format(); ?>

				<div class="report-header">
				   <img src="<?php echo e(get_logo()); ?>" class="logo"/>
				   <h4><?php echo e(_lang('Account Balances')); ?></h4>
				   <h5><?php echo e(_lang('Account Type').': '.$account_type); ?></h5>
				   <h5><?php echo e(_lang('Date').': '. date($date_format)); ?></h5>
				</div>

				<table class="table table-bordered report-table">
					<thead>
						<th><?php echo e(_lang('Member')); ?></th>
						<th><?php echo e(_lang('Account Number')); ?></th>
						<th class="text-right"><?php echo e(_lang('Balance')); ?></th>
						<th class="text-right"><?php echo e(_lang('Loan Guarantee')); ?></th>
						<th class="text-right"><?php echo e(_lang('Current Balance')); ?></th>
					</thead>
					<tbody>
						<?php if(isset($accounts)): ?>
						<?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<tr>
								<td><?php echo e($account->member->name); ?></td>
								<td><?php echo e($account->account_number); ?> - <?php echo e($account->savings_type->name); ?> (<?php echo e($account->savings_type->currency->name); ?>)</td>
								<td class="text-right"><?php echo e(decimalPlace($account->balance, currency($account->savings_type->currency->name))); ?></td>						
								<td class="text-right"><?php echo e(decimalPlace($account->blocked_amount, currency($account->savings_type->currency->name))); ?></td>						
								<td class="text-right"><?php echo e(decimalPlace($account->balance - $account->blocked_amount, currency($account->savings_type->currency->name))); ?></td>						
							</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<?php endif; ?>
				    </tbody>
				</table>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home2/itmihost/public_html/fsbms.forgedcloud.com/resources/views/backend/admin/reports/account_balances.blade.php ENDPATH**/ ?>