<?php
$inbox = request_count('messages');
$deposit_requests = request_count('deposit_requests', true);
$withdraw_requests = request_count('withdraw_requests', true);
$member_requests = request_count('member_requests', true);
$pending_loans = request_count('pending_loans', true);
$upcomming_repayments = request_count('upcomming_repayments', true);
?>

<li>
	<a href="<?php echo e(route('dashboard.index')); ?>"><i class="fas fa-th-large"></i><span><?php echo e(_lang('Dashboard')); ?></span></a>
</li>

<li>
	<a href="<?php echo e(route('branches.index')); ?>"><i class="fas fa-building"></i><span><?php echo e(_lang('Branches')); ?></span></a>
</li>

<li>
	<a href="javascript: void(0);"><i class="fas fa-user-friends"></i><span><?php echo e(_lang('Members')); ?> <?php echo xss_clean($member_requests); ?></span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('members.index')); ?>"><?php echo e(_lang('Member List')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('members.create')); ?>"><?php echo e(_lang('Add Member')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('members.import')); ?>"><?php echo e(_lang('Bulk Import')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('custom_fields.index', ['members'])); ?>"><?php echo e(_lang('Custom Fields')); ?></a></li>
		<li class="nav-item">
			<a class="nav-link" href="<?php echo e(route('members.pending_requests')); ?>">
			<?php echo e(_lang('Member Requests')); ?>

			<?php echo xss_clean($member_requests); ?>

			</a>
		</li>
	</ul>
</li>

<li>
	<a href="javascript: void(0);"><i class="fas fa-hand-holding-usd"></i><span><?php echo e(_lang('Loans')); ?> <?php echo xss_clean($pending_loans); ?></span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('loans.index')); ?>"><?php echo e(_lang('All Loans')); ?></a></li>
		<li class="nav-item">
			<a class="nav-link" href="<?php echo e(route('loans.filter', 'pending')); ?>">
				<?php echo e(_lang('Pending Loans')); ?>

				<?php echo xss_clean($pending_loans); ?>

			</a>
		</li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('loans.filter', 'active')); ?>"><?php echo e(_lang('Active Loans')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('loans.admin_calculator')); ?>"><?php echo e(_lang('Loan Calculator')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('loan_products.index')); ?>"><?php echo e(_lang('Loan Products')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('custom_fields.index', ['loans'])); ?>"><?php echo e(_lang('Custom Fields')); ?></a></li>
	</ul>
</li>

<li><a href="<?php echo e(route('loans.upcoming_loan_repayments')); ?>"><i class="fas fa-calendar-alt"></i><span><?php echo e(_lang('Upcomming Payments')); ?> <?php echo xss_clean($upcomming_repayments); ?></span></a></li>
<li><a href="<?php echo e(route('loan_payments.index')); ?>"><i class="fas fa-receipt"></i><span><?php echo e(_lang('Loan Repayments')); ?></span></a></li>

<li>
	<a href="javascript: void(0);"><i class="fas fa-landmark"></i><span><?php echo e(_lang('Accounts')); ?></span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('savings_accounts.index')); ?>"><?php echo e(_lang('Member Accounts')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('interest_calculation.calculator')); ?>"><?php echo e(_lang('Interest Calculation')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('savings_products.index')); ?>"><?php echo e(_lang('Account Types')); ?></a></li>
	</ul>
</li>

<li>
	<a href="javascript: void(0);"><i class="fas fa-coins"></i><span><?php echo e(_lang('Deposit')); ?> <?php echo xss_clean($deposit_requests); ?></span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('transactions.create')); ?>?type=deposit"><?php echo e(_lang('Deposit Money')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('deposit_requests.index')); ?>">
				<?php echo e(_lang('Deposit Requests')); ?>

				<?php echo xss_clean($deposit_requests); ?>

			</a></li>
	</ul>
</li>

<li>
	<a href="javascript: void(0);"><i class="fas fa-money-check"></i><span><?php echo e(_lang('Withdraw')); ?> <?php echo xss_clean($withdraw_requests); ?></span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('transactions.create')); ?>?type=withdraw"><?php echo e(_lang('Withdraw Money')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('withdraw_requests.index')); ?>">
				<?php echo e(_lang('Withdraw Requests')); ?>

				<?php echo xss_clean($withdraw_requests); ?>

			</a></li>
	</ul>
</li>

<li>
	<a href="javascript: void(0);"><i class="fas fa-wallet"></i><span><?php echo e(_lang('Transactions')); ?></span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('transactions.create')); ?>"><?php echo e(_lang('New Transaction')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('transactions.index')); ?>"><?php echo e(_lang('Transaction History')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('transaction_categories.index')); ?>"><?php echo e(_lang('Transaction Categories')); ?></a></li>
	</ul>
</li>

<li>
	<a href="javascript: void(0);"><i class="fas fa-money-bill-wave"></i><span><?php echo e(_lang('Expense')); ?></span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('expenses.index')); ?>"><?php echo e(_lang('Expenses')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('expense_categories.index')); ?>"><?php echo e(_lang('Categories')); ?></a></li>
	</ul>
</li>

<li>
	<a href="javascript: void(0);"><i class="fas fa-list-ul"></i><span><?php echo e(_lang('Deposit Methods')); ?></span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('automatic_methods.index')); ?>"><?php echo e(_lang('Online Gateways')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('deposit_methods.index')); ?>"><?php echo e(_lang('Offline Gateways')); ?></a></li>
	</ul>
</li>

<li>
	<a href="<?php echo e(route('withdraw_methods.index')); ?>"><i class="fas fa-clipboard-list"></i><span><?php echo e(_lang('Withdraw Methods')); ?></span></a>
</li>

<li>
	<a href="javascript: void(0);"><i class="fas fa-landmark"></i><span><?php echo e(_lang('Bank Accounts')); ?></span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('bank_accounts.index')); ?>"><?php echo e(_lang('Bank Accounts')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('bank_transactions.index')); ?>"><?php echo e(_lang('Bank Transactions')); ?></a></li>
	</ul>
</li>

<li>
	<a href="javascript: void(0);"><i class="fas fa-envelope"></i><span><?php echo e(_lang('Messages')); ?></span> <?php echo $inbox > 0 ? xss_clean('<div class="circle-animation"></div>') : ''; ?><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('messages.compose')); ?>"><?php echo e(_lang('New Message')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('messages.inbox')); ?>"><?php echo e(_lang('Inbox Items')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('messages.sent')); ?>"><?php echo e(_lang('Sent Items')); ?></a></li>
	</ul>
</li>

<li>
	<a href="javascript: void(0);"><i class="fas fa-chart-bar"></i><span><?php echo e(_lang('Reports')); ?></span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('reports.account_statement')); ?>"><?php echo e(_lang('Account Statement')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('reports.account_balances')); ?>"><?php echo e(_lang('Account Balance')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('reports.loan_report')); ?>"><?php echo e(_lang('Loan Report')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('reports.loan_due_report')); ?>"><?php echo e(_lang('Loan Due Report')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('reports.loan_repayment_report')); ?>"><?php echo e(_lang('Loan Repayment Report')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('reports.transactions_report')); ?>"><?php echo e(_lang('Transaction Report')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('reports.expense_report')); ?>"><?php echo e(_lang('Expense Report')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('reports.cash_in_hand')); ?>"><?php echo e(_lang('Cash In Hand')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('reports.bank_transactions')); ?>"><?php echo e(_lang('Bank Transactions')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('reports.bank_balances')); ?>"><?php echo e(_lang('Bank Account Balance')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('reports.revenue_report')); ?>"><?php echo e(_lang('Revenue Report')); ?></a></li>
	</ul>
</li>

<li>
	<a href="javascript: void(0);"><i class="fas fa-user-friends"></i><span><?php echo e(_lang('System Users')); ?></span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('users.index')); ?>"><?php echo e(_lang('Manage Users')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('roles.index')); ?>"><?php echo e(_lang('Roles & Permission')); ?></a></li>
	</ul>
</li>

<li>
	<a href="javascript: void(0);"><i class="ti-settings"></i><span><?php echo e(_lang('System Settings')); ?></span><span class="menu-arrow"><i class="mdi mdi-chevron-right"></i></span></a>
	<ul class="nav-second-level" aria-expanded="false">
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('settings.index')); ?>"><?php echo e(_lang('System Settings')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('currency.index')); ?>"><?php echo e(_lang('Currency Management')); ?></a></li>
		<li class="nav-item"><a class="nav-link" href="<?php echo e(route('email_templates.index')); ?>"><?php echo e(_lang('Notification Templates')); ?></a></li>
	</ul>
</li><?php /**PATH /home2/itmihost/public_html/bms.cybertranz.com/resources/views/layouts/menus/admin.blade.php ENDPATH**/ ?>