<form method="post" class="ajax-submit" autocomplete="off" action="<?php echo e(route('guarantors.store')); ?>" enctype="multipart/form-data">
	<?php echo csrf_field(); ?>
	<div class="row px-2">
	    <div class="col-md-12">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Loan ID')); ?></label>						
				<select class="form-control auto-select select2" data-selected="<?php echo e(old('loan_id')); ?>" name="loan_id" required>
					<option value=""><?php echo e(_lang('Select One')); ?></option>
					<?php $__currentLoopData = \App\Models\Loan::where('status',0)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<option value="<?php echo e($loan->id); ?>"><?php echo e($loan->loan_id); ?> (<?php echo e(_lang('Applied Amount').': '.decimalPlace($loan->applied_amount, currency($loan->currency->name))); ?>)</option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</select>
			</div>
		</div>

		<div class="col-md-12">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Guarantor')); ?></label>						
				<select class="form-control auto-select select2" data-selected="<?php echo e(old('member_id')); ?>" id="member_id" name="member_id"  required>
					<option value=""><?php echo e(_lang('Select One')); ?></option>
					<?php $__currentLoopData = \App\Models\Member::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<option value="<?php echo e($member->id); ?>"><?php echo e($member->first_name.' '.$member->last_name); ?> (<?php echo e($member->member_no); ?>)</option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</select>
			</div>
		</div>

		<div class="col-md-12">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Account Number')); ?></label>							
				<select class="form-control select2 auto-select" data-selected="<?php echo e(old('savings_account_id')); ?>" name="savings_account_id" id="savings_account_id" required>
				</select>
			</div>
		</div>

		<div class="col-md-12">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Amount')); ?></label>						
				<input type="text" class="form-control float-field" name="amount" value="<?php echo e(old('amount')); ?>" required>
			</div>
		</div>

		<div class="col-md-12 mt-2">
		    <div class="form-group">
			    <button type="submit" class="btn btn-primary"><i class="ti-check-box"></i>&nbsp;<?php echo e(_lang('Submit')); ?></button>
		    </div>
		</div>
	</div>
</form>

<script>
(function ($) {

	$(document).on('change','#member_id',function(){
		var member_id = $(this).val();
		if(member_id != ''){
			$.ajax({
				url: _tenant_url + '/savings_accounts/get_account_by_member_id/' + member_id,
				success: function(data){
					var json = JSON.parse(JSON.stringify(data));
					$("#savings_account_id").html('');
					$.each(json['accounts'], function(i, account) {
						$("#savings_account_id").append(`<option value="${account.id}">${account.account_number} (${account.savings_type.name} - ${account.savings_type.currency.name})</option>`);	
					});
		
				}
			});
		}
	});

})(jQuery);
</script>
<?php /**PATH /home2/itmihost/public_html/fsbms.forgedcloud.com/resources/views/backend/admin/guarantor/modal/create.blade.php ENDPATH**/ ?>