<?php $__env->startSection('content'); ?>

<div class="row">
	<div class="col-lg-12">
		<div class="card no-export">
		    <div class="card-header d-flex align-items-center">
				<span class="panel-title"><?php echo e(_lang('Member Requests')); ?></span>
			</div>
			<div class="card-body p-0">
				<div class="table-responsive">
					<table id="members_table" class="table">
						<thead>
							<tr>
								<th class="text-center"><?php echo e(_lang('Photo')); ?></th>
								<th><?php echo e(_lang('Member No')); ?></th>
								<th><?php echo e(_lang('First Name')); ?></th>
								<th><?php echo e(_lang('Last Name')); ?></th>
								<th><?php echo e(_lang('Email')); ?></th>
								<th><?php echo e(_lang('Branch')); ?></th>
								<th class="text-center"><?php echo e(_lang('Action')); ?></th>
							</tr>
						</thead>
						<tbody>
							<?php if(count($members) == 0): ?>
								<tr><td colspan="7" class="text-center"><?php echo e(_lang('No Data Found')); ?></td></tr>
							<?php endif; ?>
							<?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr id="row_<?php echo e($member->id); ?>">
									<td class="text-center"><img src="<?php echo e(asset('public/uploads/profile/'.$member->photo)); ?>" alt="Profile Image" style="width: 50px; height: 50px; border-radius: 50%;"></td>
									<td class='member_no'><?php echo e($member->member_no); ?></td>
									<td class='first_name'><?php echo e($member->first_name); ?></td>
									<td class='last_name'><?php echo e($member->last_name); ?></td>
									<td class='email'><?php echo e($member->email); ?></td>
									<td class='branch_id'><?php echo e($member->branch->name); ?></td>
									<td class="text-center">
										<a class="btn btn-primary btn-xs" href="<?php echo e(route('members.show',$member->id )); ?>"><i class="fas fa-eye"></i> <?php echo e(_lang('Details')); ?></a>
										<a class="btn btn-success btn-xs ajax-modal" href="<?php echo e(route('members.accept_request',$member->id )); ?>" data-title="<?php echo e(_lang('Approve Member Request')); ?>"><i class="fas fa-check-circle"></i> <?php echo e(_lang('Approve')); ?></a>
										<a class="btn btn-danger btn-xs btn-remove-2" href="<?php echo e(route('members.reject_request',$member->id )); ?>"><i class="fas fa-times-circle"></i> <?php echo e(_lang('Reject')); ?></a>
									</td>
								</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tbody>
					</table>
				</div>
				<div class="float-right">
					<?php echo e($members->links()); ?>

				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home2/itmihost/public_html/fsbms.forgedcloud.com/resources/views/backend/admin/member/pending_requests.blade.php ENDPATH**/ ?>