<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-12">
		<div class="card">
			<div class="card-header">
				<span class="panel-title"><?php echo e(_lang('Expense Report')); ?></span>
			</div>

			<div class="card-body">
				<div class="report-params">
					<form class="validate" method="post" action="<?php echo e(route('reports.expense_report')); ?>">
						<div class="row">
              				<?php echo csrf_field(); ?>

							<div class="col-xl-2 col-lg-4">
								<div class="form-group">
									<label class="control-label"><?php echo e(_lang('Start Date')); ?></label>
									<input type="text" class="form-control datepicker" name="date1" id="date1" value="<?php echo e(isset($date1) ? $date1 : old('date1')); ?>" readOnly="true" required>
								</div>
							</div>

							<div class="col-xl-2 col-lg-4">
								<div class="form-group">
									<label class="control-label"><?php echo e(_lang('End Date')); ?></label>
									<input type="text" class="form-control datepicker" name="date2" id="date2" value="<?php echo e(isset($date2) ? $date2 : old('date2')); ?>" readOnly="true" required>
								</div>
							</div>

							<div class="col-xl-3 col-lg-4">
								<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Expense Category')); ?></label>
									<select class="form-control auto-select" data-selected="<?php echo e(isset($category) ? $category : old('category')); ?>" name="category">
										<option value=""><?php echo e(_lang('All')); ?></option>
										<?php $__currentLoopData = $expense_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<option value="<?php echo e($expense_category->id); ?>"><?php echo e($expense_category->name); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
								</div>
							</div>

							<?php if(auth()->user()->user_type == 'admin'): ?>
							<div class="col-xl-3 col-lg-4">
								<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Branch')); ?></label>
									<select class="form-control auto-select" data-selected="<?php echo e(isset($branch) ? $branch : old('branch')); ?>" name="branch">
										<option value=""><?php echo e(_lang('All')); ?></option>
										<?php $__currentLoopData = \App\Models\Branch::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<option value="<?php echo e($branch->id); ?>"><?php echo e($branch->name); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
								</div>
							</div>
							<?php endif; ?>

							<div class="col-xl-2 col-lg-4">
								<button type="submit" class="btn btn-light btn-xs btn-block mt-26"><i class="ti-filter"></i>&nbsp;<?php echo e(_lang('Filter')); ?></button>
							</div>
						</form>

					</div>
				</div><!--End Report param-->

				<?php $date_format = get_date_format(); ?>
				<?php $currency = currency(get_base_currency()); ?>

				<div class="report-header">
				   <img src="<?php echo e(get_logo()); ?>" class="logo"/>
				   <h4><?php echo e(_lang('Expense Report')); ?></h4>
				   <h5><?php echo e(isset($date1) ? date($date_format, strtotime($date1)).' '._lang('to').' '.date($date_format, strtotime($date2)) : '----------  '._lang('to').'  ----------'); ?></h5>
				</div>

				<table class="table table-bordered report-table">
					<thead>
                        <th><?php echo e(_lang('Date')); ?></th>
						<th><?php echo e(_lang('Reference')); ?></th>
                        <th><?php echo e(_lang('Expense Type')); ?></th>
                        <th class="text-right"><?php echo e(_lang('Amount')); ?></th>
					</thead>
					<tbody>
					<?php if(isset($report_data)): ?>
						<?php $__currentLoopData = $report_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<tr>
								<td><?php echo e($expense->expense_date); ?></td>
								<td><?php echo e($expense->reference); ?></td>
								<td><?php echo e($expense->expense_category->name); ?></td>
								<td class="text-right"><?php echo e(decimalPlace($expense->amount, $currency)); ?></td>
							</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<?php if(count($report_data) > 0): ?>
							<tr>
								<td><?php echo e($expense->expense_date); ?></td>
								<td></td>
								<td><b><?php echo e(_lang('Total Expenses')); ?></b></td>
								<td class="text-right"><b><?php echo e(decimalPlace($report_data->sum('amount'), $currency)); ?></b></td>
							</tr>
						<?php endif; ?>
					<?php endif; ?>
				    </tbody>
				</table>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home2/itmihost/public_html/fsbms.forgedcloud.com/resources/views/backend/admin/reports/expense_report.blade.php ENDPATH**/ ?>