<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-12">
		<div class="card">
			<div class="card-header">
				<span class="panel-title"><?php echo e(_lang('Loan Repayment Report')); ?></span>
			</div>

			<div class="card-body">

				<div class="report-params">
					<form class="validate" method="post" action="<?php echo e(route('reports.loan_repayment_report')); ?>">
						<div class="row">
              				<?php echo csrf_field(); ?>

							<div class="col-xl-3 col-lg-4">
								<div class="form-group">
									<label class="control-label"><?php echo e(_lang('Loan ID')); ?></label>
                                    <select class="form-control auto-select select2" data-selected="<?php echo e(isset($report_data) ? $report_data->id : old('loan_id')); ?>" id="loan_id" name="loan_id" required>
                                        <option value=""><?php echo e(_lang('Select One')); ?></option>
                                        <?php $__currentLoopData = \App\Models\Loan::with(['currency', 'borrower'])->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($loan->id); ?>"><?php echo e($loan->loan_id); ?> (<?php echo e($loan->borrower->name); ?>) (<?php echo e(_lang('Total Due').' '.decimalPlace($loan->applied_amount - $loan->total_paid, currency($loan->currency->name))); ?>)</option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
								</div>
							</div>

							<div class="col-xl-2 col-lg-4">
								<button type="submit" class="btn btn-light btn-xs btn-block mt-26"><i class="ti-filter"></i>&nbsp;<?php echo e(_lang('Filter')); ?></button>
							</div>
						</form>

					</div>
				</div><!--End Report param-->

				<?php $date_format = get_date_format(); ?>
				<?php $currency = currency(); ?>

				<div class="report-header">
				   <img src="<?php echo e(get_logo()); ?>" class="logo"/>
				   <h4><?php echo e(_lang('Loan Repayment Report')); ?></h4>

                   <?php if(isset($report_data)): ?>
				   <p><?php echo e(_lang('Loan ID').': '.$report_data->loan_id); ?></p>
				   <p><?php echo e(_lang('Member No').': '.$report_data->borrower->member_no); ?>, <?php echo e(_lang('Borrower').': '.$report_data->borrower->name); ?></p>
                   <p><?php echo e(_lang('Applied Amount').': '.decimalPlace($report_data->applied_amount, currency($report_data->currency->name))); ?>, <?php echo e(_lang('Due Amount').': '.decimalPlace(($report_data->applied_amount - $report_data->total_paid), currency($report_data->currency->name))); ?> </p>

                   <?php if($report_data->status == 0): ?>
                        <p><?php echo e(_lang('Loan Status').': '._lang('Pending')); ?></p>
                    <?php elseif($report_data->status == 1): ?>
                        <p><?php echo e(_lang('Loan Status').': '._lang('Approved')); ?></p>
                    <?php elseif($report_data->status == 2): ?>
                        <p><?php echo e(_lang('Loan Status').': '._lang('Completed')); ?></p>
                    <?php elseif($report_data->status == 3): ?>
                        <p><?php echo e(_lang('Loan Status').': '._lang('Cancelled')); ?></p>
                    <?php endif; ?>
                   <?php endif; ?>
				</div>

				<table class="table table-bordered report-table">
					<thead>
                        <th><?php echo e(_lang('Payment Date')); ?></th>
                        <th><?php echo e(_lang('Principal Amount')); ?></th>
                        <th><?php echo e(_lang('Interest')); ?></th>
                        <th><?php echo e(_lang('Late Penalties')); ?></th>
                        <th><?php echo e(_lang('Total Amount')); ?></th>
					</thead>
					<tbody>
					<?php if(isset($report_data)): ?>
						<?php $__currentLoopData = $report_data->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loanPayment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<tr>
								<td><?php echo e($loanPayment->paid_at); ?></td>
								<td><?php echo e(decimalPlace($loanPayment->repayment_amount - $loanPayment->interest , currency($report_data->currency->name))); ?></td>
								<td><?php echo e(decimalPlace($loanPayment->interest, currency($report_data->currency->name))); ?></td>
								<td><?php echo e(decimalPlace($loanPayment->late_penalties, currency($report_data->currency->name))); ?></td>
								<td><?php echo e(decimalPlace($loanPayment->total_amount, currency($report_data->currency->name))); ?></td>
							</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(_lang('Total')); ?></td>
                            <td><?php echo e(decimalPlace($report_data->payments->sum('repayment_amount') - $report_data->payments->sum('interest') , currency($report_data->currency->name))); ?></td>
                            <td><?php echo e(decimalPlace($report_data->payments->sum('interest'), currency($report_data->currency->name))); ?></td>
                            <td><?php echo e(decimalPlace($report_data->payments->sum('late_penalties'), currency($report_data->currency->name))); ?></td>
                            <td><?php echo e(decimalPlace($report_data->payments->sum('total_amount'), currency($report_data->currency->name))); ?></td>
                        </tr>
					<?php endif; ?>
				    </tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home2/itmihost/public_html/fsbms.forgedcloud.com/resources/views/backend/admin/reports/loan_repayment_report.blade.php ENDPATH**/ ?>