@extends('layouts.app')

@section('content')
<div class="row">
	<div class="col-lg-12">
		<div class="card">
		    <div class="card-header d-flex align-items-center">
				<span class="panel-title">{{ _lang('Bank Accounts') }}</span>
				<a class="btn btn-primary btn-xs ml-auto ajax-modal" data-title="{{ _lang('Add Bank Account') }}" href="{{ route('bank_accounts.create') }}"><i class="ti-plus"></i> {{ _lang('Add New') }}</a>
			</div>
			<div class="card-body">
				<table id="bank_accounts_table" class="table table-bordered data-table">
					<thead>
					    <tr>
						    <th>{{ _lang('Opening Date') }}</th>
						    <th>{{ _lang('Bank Name') }}</th>
						    <th>{{ _lang('Currency') }}</th>
							<th>{{ _lang('Account Name') }}</th>
							<th>{{ _lang('Account Number') }}</th>
							<th class="text-center">{{ _lang('Action') }}</th>
					    </tr>
					</thead>
					<tbody>
					    @foreach($bankAccounts as $bankAccount)
					    <tr data-id="row_{{ $bankAccount->id }}">
							<td class='opening_date'>{{ $bankAccount->opening_date }}</td>
							<td class='bank_name'>{{ $bankAccount->bank_name }}</td>
							<td class='currency_id'>{{ $bankAccount->currency->name }}</td>
							<td class='account_name'>{{ $bankAccount->account_name }}</td>
							<td class='account_number'>{{ $bankAccount->account_number }}</td>
							
							<td class="text-center">
								<span class="dropdown">
								  <button class="btn btn-primary dropdown-toggle btn-xs" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								  {{ _lang('Action') }}
								  </button>
								  <form action="{{ route('bank_accounts.destroy', $bankAccount['id']) }}" method="post">
									@csrf
									<input name="_method" type="hidden" value="DELETE">

									<div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
										<a href="{{ route('bank_accounts.edit', $bankAccount['id']) }}" data-title="{{ _lang('Update Bank Account') }}" class="dropdown-item dropdown-edit ajax-modal"><i class="fas fa-pencil-alt"></i> {{ _lang('Edit') }}</a>
										<a href="{{ route('bank_accounts.show', $bankAccount['id']) }}" data-title="{{ _lang('Bank Account Details') }}" class="dropdown-item dropdown-view ajax-modal"><i class="fas fa-eye"></i> {{ _lang('View') }}</a>
										<button class="btn-remove dropdown-item" type="submit"><i class="fas fa-trash-alt"></i> {{ _lang('Delete') }}</button>
									</div>
								  </form>
								</span>
							</td>
					    </tr>
					    @endforeach
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
@endsection