<?php
/**
 * Header
 *
 * @package quper
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
$cls ='';

// Get header style
$cls = quper_get_mod( 'header_class' );
$header_style = quper_get_mod( 'header_site_style', 'style-1' );
if ( is_page() && quper_metabox( 'header_style' ) )
	$header_style = quper_metabox( 'header_style' );

if ( is_page() && quper_elementor( 'header_style' ) )
    $header_style = quper_elementor( 'header_style' );

// Custom style for main header area
$header_css = '';
if ( is_page() && $bg = quper_metabox( 'header_background' ) )
	$header_css = 'background-color: '. $bg .';';

// Extra class
if ( quper_metabox( 'header_extra' ) ) $cls = quper_metabox( 'header_extra' );
if ( quper_elementor( 'header_extra' ) ) $cls = quper_elementor( 'header_extra' );
?>

<?php get_template_part( 'templates/header-extra-nav' ); ?>

<header id="site-header" class="<?php echo esc_attr( $cls ); ?>" style="<?php echo esc_attr( $header_css ); ?>">
    <?php if ( $header_style == 'style-1' || $header_style == 'style-1 header-float' ) { ?>
        <div class="top-bar clearfix">
            <div class="quper-container">
                <div class="topbar-left">
                    <?php get_template_part( 'templates/header-info'); ?>
                </div>
                
                <div class="topbar-right">
                    <?php get_template_part( 'templates/header-social'); ?>
                </div>        
            </div>
        </div>

        <div class="quper-container">
        	<div class="site-header-inner">
                <?php get_template_part( 'templates/header-logo'); ?>
                
                <div class="wrap-inner">
            		<?php 
                    get_template_part( 'templates/header-menu');       
            		get_template_part( 'templates/header-button');
            		?>
                </div>
        	</div>
        </div>
    <?php } elseif ( $header_style == 'style-2' || $header_style == 'style-2 header-float' ) { ?>
        <div class="site-header-inner">
            <?php get_template_part( 'templates/header-logo'); ?>
            
            <div class="wrap-inner">
                <?php 
                get_template_part( 'templates/header-menu');       
                get_template_part( 'templates/header-button');
                ?>
            </div>
        </div>
    <?php } elseif ( $header_style == 'style-3' ) { ?>
        <div class="quper-container clearfix">
            <div class="header-top">
                <?php get_template_part( 'templates/header-logo'); ?>
                <?php get_template_part( 'templates/header-info'); ?>
            </div>
            
            <div class="site-header-inner">
                 <div class="wrap-inner">
                    <?php 
                    get_template_part( 'templates/header-menu'); 
                    ?>
                </div>
            </div>        
        </div>
    <?php } else { ?>
        <div class="top-bar clearfix">
            <div class="quper-container">
                <div class="topbar-left">
                    <?php get_template_part( 'templates/header-info'); ?>
                </div>
                
                <div class="topbar-right">
                    <?php get_template_part( 'templates/header-social'); ?>
                </div>        
            </div>
        </div>

        <div class="quper-container">
            <div class="site-header-inner">
                <?php get_template_part( 'templates/header-logo'); ?>
                <div class="wrap-inner">
                    <?php 
                    get_template_part( 'templates/header-menu');       
                    get_template_part( 'templates/header-button');
                    ?>
                </div>
            </div>
        </div>
    <?php } ?>
</header><!-- /#site-header -->
