<?php
/**
 * Metabox Options
 *
 * @package quper
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Return the registered-widget array
function quper_get_widget_registered() {
	global $wp_registered_sidebars;

	$widgets_areas = array();
	if ( ! empty( $wp_registered_sidebars ) ) {
		foreach ( $wp_registered_sidebars as $widget_area ) {
			$name = isset ( $widget_area['name'] ) ? $widget_area['name'] : '';
			$id = isset ( $widget_area['id'] ) ? $widget_area['id'] : '';
			if ( $name && $id ) {
				$widgets_areas[$id] = $name;
			}
		}
	}

	return $widgets_areas;
}

// Return the all-widget array
function quper_get_widget_mods() {
	$new_arr = array();
	$widget_areas_mod = quper_get_mod( 'widget_areas' );
	
	if (is_array($widget_areas_mod) || is_object($widget_areas_mod)) {
		foreach( $widget_areas_mod as $key ) {
			$new_arr[sanitize_key($key)] = $key;
		}
	}
	
	$widget_areas = quper_get_widget_registered() + $new_arr;

	return $widget_areas;
}

// Get post meta, using rwmb_meta() function from Meta Box class
function quper_metabox( $key, $args = array(), $post_id = null ) {
    if ( ! function_exists( 'rwmb_meta' ) )
      	return false;
    return rwmb_meta( $key, $args, $post_id );
}

// Registering meta boxes. Using Meta Box plugin: https://metabox.io/
function quper_register_meta_boxes( $meta_boxes ) {
	// Element Thumbnail
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Element Thumbnail', 'quper' ),
		'id'     => 'opt-meta-box-element-thumbnail',
		'pages'  => array( 'post' ),
		'fields' => array(
			array(
				'name' => esc_html__( 'Image', 'quper' ),
				'id'   => 'element_thumbnail',
				'type' => 'image_advanced',
				'max_file_uploads' => 1
			),
		),
	);
	
	// Post Format Gallery
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Post Format: Gallery', 'quper' ),
		'id'     => 'opt-meta-box-post-format-gallery',
		'pages'  => array( 'post' ),
		'fields' => array(
			array(
				'name' => esc_html__( 'Images', 'quper' ),
				'id'   => 'gallery_images',
				'type' => 'image_advanced',
			),
		),
	);

	// Post Format Video
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Post Format: Video ( Embeded video from youtube, vimeo...)', 'quper' ),
		'id'     => 'opt-meta-box-post-format-video',
		'pages'  => array( 'post' ),
		'fields' => array(
			array(
				'name' => esc_html__( 'Video URL or Embeded Code', 'quper' ),
				'id'   => 'video_url',
				'type' => 'textarea',
			),
		)
	);

	// Short Description
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Short Description', 'quper' ),
		'id'     => 'opt-meta-box-short-desc',
		'pages'  => array( 'post' ),
		'fields' => array(
			array(
				'name' => esc_html__( 'Short Description', 'quper' ),
				'id'   => 'post-desc',
				'type' => 'textarea',
			),
		)
	);

	// Portfolio
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Project Settings', 'quper' ),
		'id'     => 'opt-meta-box-project',
		'pages'  => array( 'project' ),
		'fields' => array(
			array(
				'name' => esc_html__( 'Custom Title', 'quper' ),
				'id'   => 'title',
				'type' => 'textarea',
			),
			array(
				'name' => esc_html__( 'Short Description', 'quper' ),
				'id'   => 'project_desc',
				'type' => 'textarea',
			),
		)
	);

	// Single Section
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Single Section Settings', 'quper' ),
		'id'     => 'opt-meta-box-pages',
		'pages'  => array( 'section' ),
		'fields' => array(
			array(
				'name' => esc_html__( 'Show on Shop Page ?', 'quper' ),
				'id'   => 'single_section_shop',
				'type' => 'checkbox',
			),
			array(
				'name' => esc_html__( 'Show on Product Single Page ?', 'quper' ),
				'id'   => 'single_section_shop_single',
				'type' => 'checkbox',
			),
			array(
				'name' => esc_html__( 'Show on Single Post ?', 'quper' ),
				'id'   => 'single_section_post',
				'type' => 'checkbox',
			),
			array(
				'name' => esc_html__( 'Show on Single Project ?', 'quper' ),
				'id'   => 'single_section_project',
				'type' => 'checkbox',
			),
		)
	);

	// Header Settings
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Header Settings', 'quper' ),
		'id'     => 'opt-meta-box-header',
		'pages'  => array( 'page' ),
		'fields' => array(
			array(
				'name' => esc_html__( 'Custom Logo', 'quper' ),
			    'type' => 'single_image',
			    'id'   => 'custom_header_logo',
			),
			array(
				'name' => esc_html__( 'Logo Width', 'quper' ),
			    'type' => 'text',
			    'id'   => 'logo_width',
			),
			array(
				'name'    => esc_html__( 'Style', 'quper' ),
				'id'      => 'header_style',
				'type'    => 'select',
				'options' => array(
					'' => esc_html__( 'Default', 'quper' ),
					'style-1' => esc_html__( 'Basic', 'quper' ),
					'style-2' => esc_html__( 'Modern', 'quper' ),
				),
				'std'     => '',
			),
			array(
			    'name'	=> esc_html__( 'Background', 'quper' ),
			    'id'	=> 'header_background',
			    'type'	=> 'color',
			    'alpha_channel' => true,
			    'js_options'    => array(
			        'palettes' => array( '#000000', '#ffffff', '#f27507', '#0fc392', '#f37a32', '#bb5bd6', '#32b1f3', '#f87055' )
			    ),
			),
			array(
				'type'		=>	'text',
				'name'		=>	esc_html__( 'Header Extra Class', 'quper' ),
				'id'		=>	'header_extra',
			),
			array(
				'type'		=>	'text',
				'name'		=>	esc_html__( 'Button Extra Class', 'quper' ),
				'id'		=>	'header_button_extra',
			),
		)
	);

	// Featured Title Settings
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Featured Title Settings', 'quper' ),
		'id'     => 'opt-meta-box-featured-title',
		'pages'  => array( 'page' ),
		'fields' => array(
			array(
				'name' => esc_html__( 'Hide?', 'quper' ),
				'id'   => 'hide_featured_title',
				'type' => 'checkbox',
			),
			array(
				'type'		=>	'image_advanced',
				'name'		=>	esc_html__( 'Background', 'quper' ),
				'id'		=>	'featured_title_bg',
			    'max_file_uploads' => 1,
			),
			array(
				'type'		=>	'text',
				'name'		=>	esc_html__( 'Custom Title', 'quper' ),
				'id'		=>	'custom_featured_title',
			),
		)
	);

	// Main Content Settings
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Main Content Settings', 'quper' ),
		'id'     => 'opt-meta-box-main-content',
		'pages'  => array( 'page' ),
		'fields' => array(
			array(
				'name'    => esc_html__( 'Layout Position', 'quper' ),
				'id'      => 'page_layout',
				'type'    => 'image_select',
				'options' => array(
					'no-sidebar'  => get_template_directory_uri() . '/assets/admin/img/full-content.png',
					'sidebar-left'  => get_template_directory_uri() . '/assets/admin/img/sidebar-left.png',
					'sidebar-right' => get_template_directory_uri() . '/assets/admin/img/sidebar-right.png',
				),
				'std' 		=> 'no-sidebar',
			),
			array(
				'name'    => esc_html__( 'Sidebar', 'quper' ),
				'id'      => 'page_sidebar',
				'type'    => 'select',
				'options' => quper_get_widget_mods(),
				'std'     => 'sidebar-page',
				'desc'    => esc_html__( 'This option do not apply if Layout Position is full-width.', 'quper' )
			),
			array(
			    'name'          => 'Background Color',
			    'id'            => 'main_content_bg',
			    'type'          => 'color',
			    'alpha_channel' => true,
			),
			array(
				'type'		=>	'image_advanced',
				'name'		=>	esc_html__( 'Background Image', 'quper' ),
				'id'		=>	'main_content_bg_img',
			    'max_file_uploads' => 1,
			),
			array(
				'name' => esc_html__( 'Remove: Top & Bottom Padding?', 'quper' ),
				'id'   => 'hide_padding_content',
				'type' => 'checkbox',
			),
		)
	);

	// Footer Settings
	$meta_boxes[] = array(
		'title'  => esc_html__( 'Footer Settings', 'quper' ),
		'id'     => 'opt-meta-box-footer',
		'pages'  => array( 'page' ),
		'fields' => array(
			array(
				'name' => esc_html__( 'Hide: Footer?', 'quper' ),
				'id'   => 'hide_footer',
				'type' => 'checkbox',
			),
			array(
			    'name'          => 'Footer Widget: Background',
			    'id'            => 'footer_bg',
			    'type'          => 'color',
			    'alpha_channel' => true,
			),
			array(
				'type'		=>	'image_advanced',
				'name'		=>	esc_html__( 'Footer Widget: Image Background', 'quper' ),
				'id'		=>	'footer_bg_img',
			    'max_file_uploads' => 1,
			),
			array(
				'type'		=>	'text',
				'name'		=>	esc_html__( 'Footer Class', 'quper' ),
				'id'		=>	'footer_class',
			),
			array(
				'name'    => esc_html__( 'Bottom Style', 'quper' ),
				'id'      => 'bottom_bar_style',
				'type'    => 'select',
				'options' => array(
					'' => esc_html__( 'Default', 'quper' ),
					'style-1' => esc_html__( 'Only Copyright', 'quper' ),
					'style-2' => esc_html__( 'Logo + Copyright', 'quper' ),
				),
				'std'     => '',
			),
			array(
			    'name'          => 'Bottom Bar: Background',
			    'id'            => 'bottom_bg',
			    'type'          => 'color',
			    'alpha_channel' => true,
			),
			array(
				'type'		=>	'text',
				'name'		=>	esc_html__( 'Bottom Class', 'quper' ),
				'id'		=>	'bottom_class',
			),
		)
	);

	return $meta_boxes;
}
add_filter( 'rwmb_meta_boxes', 'quper_register_meta_boxes' );