<?php
namespace Quper\Settings;

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Plugin;
use Elementor\Repeater;
use Elementor\Icons_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow as Group_Control_Box_Shadow;
use Elementor\Modules\DynamicTags\Module as TagsModule;

class Quper_Settings
{

    public function __construct()
    {	
    	add_action('elementor/documents/register_controls', [$this, 'quper_register_settings'], 10);
    }

    public function quper_register_settings($element)
    {	 	
    	$post_id = $element->get_id();
    	$post_type = get_post_type($post_id);

        //$default = [];


        $this->quper_general_settings($element);

    	if ( ($post_type !== 'project') 
            && ($post_type !== 'post') 
            && ($post_type !== 'service') 
            && ($post_type !== 'pre_footer') )
    		$this->quper_page_settings($element);

    	if ( is_singular( 'project' ) ) 
    		$this->quper_project_settings($element);

        if ( is_singular( 'post' ) ) {
            $this->quper_post_settings($element);
            //$this->quper_update_post($element);
        }

        if ( is_singular( 'pre_footer' ) ) 
            $this->quper_prefooter_settings($element);  	
    }

    public function quper_general_settings($element) {
        $element->start_controls_section(
            'quper_general_settings',
            [
                'label' => __('Page Settings', 'quper'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );

        $element->add_control(
            'layout',
            [
                'label'     => __( 'Layout', 'quper'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'after'
            ]
        );

        $element->add_control(
            'site_layout_position',
            [
                'label' => __( 'Sidebar Position', 'quper' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'sidebar-left' => [
                        'title' => __( 'Sidebar Left', 'quper' ),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'no-sidebar' => [
                        'title' => __( 'No Sidebar', 'quper' ),
                        'icon' => 'eicon-ban',
                    ],
                    'sidebar-right' => [
                        'title' => __( 'Sidebar Right', 'quper' ),
                        'icon' => 'eicon-h-align-right',
                    ],
                ],
            ]
        );

        // Featured Title
        $element->add_control(
            'featured_title_heading',
            [
                'label'     => __( 'Featured Title', 'quper'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'after'
            ]
        );

        $element->add_control(
            'hide_featured_title',
            [
                'label'     => __( 'Hide?', 'quper'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'block',
                'options'   => [
                    'none'       => __( 'Yes', 'quper'),
                    'block'      => __( 'No', 'quper'),
                ],
                'selectors'  => [
                    '{{WRAPPER}} #featured-title' => 'display: {{VALUE}};',
                ],
            ]
        );

        $element->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'featured_title_bg',
                'label' => __( 'Background', 'quper' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} #featured-title',
                'condition' => [ 'hide_featured_title' => 'block' ]
            ]
        );

        $element->add_control(
            'custom_featured_title',
            [
                'label'   => __( 'Custom Title', 'quper' ),
                'type'    => Controls_Manager::TEXT,
                'label_block' => true,
                'condition' => [ 'hide_featured_title' => 'block' ]
            ]
        );

        $element->add_control(
            'main_content_heading',
            [
                'label'     => __( 'Main Content', 'quper'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'after'
            ]
        );

        $element->add_responsive_control(
            'content_padding',
            [
                'label' => __('Content Padding', 'quper'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'allowed_dimensions' => [ 'top', 'bottom' ],
                'selectors' => [ 
                    '{{WRAPPER}} #page #main-content' => 'padding-top: {{TOP}}{{UNIT}}; padding-bottom: {{BOTTOM}}{{UNIT}};',
                ],
            ]
        );

        $element->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'main_content_bg',
                'label' => __( 'Background', 'quper' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} #main-content',
            ]
        );

        $element->end_controls_section();
    }

    public function quper_page_settings($element) {
        // Header
        $element->start_controls_section(
            'quper_header_settings',
            [
                'label' => __('Header', 'quper'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );

        $element->add_control(
            'header_heading',
            [
                'label'     => __( 'Header', 'quper'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'after'
            ]
        );

        $element->add_control(
            'header_style',
            [
                'label'     => __( 'Header Style', 'quper'),
                'type'      => Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    ''             => __( 'Default', 'quper'),
                    'style-1'               => __( 'Basic', 'quper'),
                    'style-1 header-float'  => __( 'Basic - Float', 'quper'),
                    'style-2'               => __( 'Full Width', 'quper'),
                    'style-2 header-float'  => __( 'Full Width - Float', 'quper'),
                    'style-3'               => __( 'Modern', 'quper'),
                    'style-4'               => __( 'Aside', 'quper'),
                ],
                'description' => __( 'Update and refresh page to view change', 'quper' )
            ]
        );

        // Logo
        $element->add_control(
            'logo_heading',
            [
                'label'     => __( 'Logo', 'quper'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'after'
            ]
        );

        $element->add_control(
            'custom_logo',
            [
                'label'   => __( 'Custom Logo', 'quper' ),
                'type'    => Controls_Manager::MEDIA,
            ]
        );

        $element->add_responsive_control(
            'logo_width',
            [
                'label'      => __( 'Logo Width', 'quper' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range'      => [
                    'px' => [
                        'min' => 30,
                        'max' => 500,
                    ],
                    '%' => [
                        'min' => 50,
                        'max' => 150,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} #site-logo #site-logo-inner' => 'max-width: {{SIZE}}{{UNIT}} !important;',
                ],
                50
            ]
        );

        $element->add_control(
            'header_extra',
            [
                'label'   => __( 'Extra Classes', 'quper' ),
                'type'    => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $element->end_controls_section();

        // Footer
        $element->start_controls_section(
            'quper_footer_settings',
            [
                'label' => __('Footer', 'quper'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );

        $element->add_control(
            'footer_heading',
            [
                'label'     => __( 'Footer', 'quper'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'after'
            ]
        );

        $element->add_control(
            'hide_footer',
            [
                'label'     => __( 'Hide?', 'quper'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'block',
                'options'   => [
                    'none'       => __( 'Yes', 'quper'),
                    'block'      => __( 'No', 'quper'),
                ],
                'selectors'  => [
                    '{{WRAPPER}} #footer' => 'display: {{VALUE}};' 
                ],
            ]
        );

        $element->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'footer_bg',
                'label' => __( 'Background', 'quper' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} #footer',
                'condition' => [ 'hide_footer' => 'block' ]
            ]
        );

        // Bottom
        $element->add_control(
            'bottom_heading',
            [
                'label'     => __( 'Bottom Bar', 'quper'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'after'
            ]
        );

        $element->add_control(
            'hide_bottom',
            [
                'label'     => __( 'Hide?', 'quper'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'block',
                'options'   => [
                    'none'       => __( 'Yes', 'quper'),
                    'block'      => __( 'No', 'quper'),
                ],
                'selectors'  => [
                    '{{WRAPPER}} #bottom' => 'display: {{VALUE}};' 
                ],
            ]
        );

        $element->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'bottom_bg',
                'label' => __( 'Background', 'quper' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} #bottom',
                'condition' => [ 'hide_bottom!' => 'none']
            ]
        );

        $element->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'bottom_border',
                'label' => __( 'Border', 'quper' ),
                'selector' => '{{WRAPPER}} #bottom',
                'fields_options' => [
                    'border' => [ 'default' => 'solid', ],
                    'width' => [ 
                        'default' => [
                            'top' => 1,
                            'left' => 0,
                            'bottom' => 0,
                            'right' => 0,
                        ] 
                    ]
                ],
                'condition' => [ 'hide_bottom!' => 'none']
            ]
        );

        $element->end_controls_section();
    }

    public function quper_project_settings($element) {
    	$element->start_controls_section(
            'quper_project_settings',
            [
                'label' => __('Project Settings', 'quper'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );

        $element->add_control(
            'project_title',
            [
                'label'   => __( 'Custom Title', 'quper' ),
                'type'    => Controls_Manager::TEXT,
            ]
        );

        $element->add_control(
            'project_desc',
            [
                'label'      => __( 'Short Description', 'quper' ),
                'type'       => Controls_Manager::WYSIWYG,
            ]
        );

        $element->end_controls_section();
    }

    public function quper_post_settings($element) {

        $element->start_controls_section(
            'quper_post_settings',
            [
                'label' => __('Post Settings', 'quper'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );


        $element->add_control(
            'video_url',
            [
                'label'     => __( 'Video URL or Embeded Code', 'quper'),
                'type'      => Controls_Manager::TEXT,
                'default'   => '',
            ]
        );

        $element->add_control(
            'gallery_images',
            [
                'label' => __( 'Add Images', 'quper' ),
                'type' => Controls_Manager::GALLERY,
                'default' => [],
            ]
        );

        $element->end_controls_section();
    }

    public function quper_prefooter_settings($element) {
        $element->start_controls_section(
            'quper_prefooter_settings',
            [
                'label' => __('Pre-footer Settings', 'quper'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );

        $element->add_control(
            'pre_footer_heading',
            [
                'label'        => __( 'Show on page', 'quper' ),
                'type'         => Controls_Manager::HEADING,
            ]
        );

        $element->add_control(
            'pre_footer_blog',
            [
                'label'        => __( 'Blog', 'quper' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'On', 'quper' ),
                'label_off'    => __( 'Off', 'quper' ),
                'return_value' => 'yes',
                'default'      => ''
            ]
        );

        $element->add_control(
            'pre_footer_single_post',
            [
                'label'        => __( 'Blog Single', 'quper' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'On', 'quper' ),
                'label_off'    => __( 'Off', 'quper' ),
                'return_value' => 'yes',
                'default'      => ''
            ]
        );

        $element->add_control(
            'pre_footer_shop',
            [
                'label'        => __( 'Shop', 'quper' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'On', 'quper' ),
                'label_off'    => __( 'Off', 'quper' ),
                'return_value' => 'yes',
                'default'      => ''
            ]
        );

        $element->add_control(
            'pre_footer_product',
            [
                'label'        => __( 'Product', 'quper' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'On', 'quper' ),
                'label_off'    => __( 'Off', 'quper' ),
                'return_value' => 'yes',
                'default'      => ''
            ]
        );

        $element->add_control(
            'pre_footer_project_single',
            [
                'label'        => __( 'Project Single', 'quper' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'On', 'quper' ),
                'label_off'    => __( 'Off', 'quper' ),
                'return_value' => 'yes',
                'default'      => ''
            ]
        );

        $element->end_controls_section();
    }
}

new Quper_Settings();