<?php
/**
 * Layout setting for Customizer
 *
 * @package quper
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Layout Style
$this->sections['quper_layout_style'] = array(
	'title' => esc_html__( 'Layout Site', 'quper' ),
	'panel' => 'quper_layout',
	'settings' => array(
		array(
			'id' => 'site_layout_style',
			'default' => 'full-width',
			'control' => array(
				'label' => esc_html__( 'Layout Style', 'quper' ),
				'type' => 'select',
				'choices' => array(
					'full-width' => esc_html__( 'Full Width','quper' ),
					'boxed' => esc_html__( 'Boxed','quper' )
				),
			),
		),
		array(
			'id' => 'site_layout_boxed_shadow',
			'control' => array(
				'label' => esc_html__( 'Box Shadow', 'quper' ),
				'type' => 'checkbox',
				'active_callback' => 'quper_cac_has_boxed_layout',
			),
		),
		array(
			'id' => 'site_layout_wrapper_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Wrapper Margin', 'quper' ),
				'desc' => esc_html__( 'Top Right Bottom Left. Default: 30px 0px 30px 0px.', 'quper' ),
				'active_callback' => 'quper_cac_has_boxed_layout',
			),
			'inline_css' => array(
				'target' => '.site-layout-boxed #wrapper',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'wrapper_background_color',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Outer Background Color', 'quper' ),
				'type' => 'color',
				'active_callback' => 'quper_cac_has_boxed_layout',
			),
			'inline_css' => array(
				'target' => '.site-layout-boxed #wrapper',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'wrapper_background_img',
			'control' => array(
				'label' => esc_html__( 'Outer Background Image', 'quper' ),
				'type' => 'image',
				'active_callback' => 'quper_cac_has_boxed_layout',
			),
		),
		array(
			'id' => 'wrapper_background_img_style',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Outer Background Image Style', 'quper' ),
				'type'  => 'image',
				'type'  => 'select',
				'choices' => array(
					''             => esc_html__( 'Default', 'quper' ),
					'cover'        => esc_html__( 'Cover', 'quper' ),
					'center-top'        => esc_html__( 'Center Top', 'quper' ),
					'fixed-top'    => esc_html__( 'Fixed Top', 'quper' ),
					'fixed'        => esc_html__( 'Fixed Center', 'quper' ),
					'fixed-bottom' => esc_html__( 'Fixed Bottom', 'quper' ),
					'repeat'       => esc_html__( 'Repeat', 'quper' ),
					'repeat-x'     => esc_html__( 'Repeat-x', 'quper' ),
					'repeat-y'     => esc_html__( 'Repeat-y', 'quper' ),
				),
				'active_callback' => 'quper_cac_has_boxed_layout',
			),
		),
	),
);

// Layout Position
$this->sections['quper_layout_position'] = array(
	'title' => esc_html__( 'Layout Position', 'quper' ),
	'panel' => 'quper_layout',
	'settings' => array(
		array(
			'id' => 'site_layout_position',
			'default' => 'sidebar-right',
			'control' => array(
				'label' => esc_html__( 'Site Layout Position', 'quper' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'quper' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'quper' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'quper' ),
				),
				'desc' => esc_html__( 'Specify layout for all pages on website. (e.g. pages, blog posts, single post, archives, etc ). Single page can override this setting in Page Settings elementor when edit.', 'quper' )
			),
		),
		array(
			'id' => 'custom_page_layout_position',
			'default' => 'no-sidebar',
			'control' => array(
				'label' => esc_html__( 'Custom Page Layout Position', 'quper' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'quper' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'quper' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'quper' ),
				),
				'desc' => esc_html__( 'Specify layout for all custom pages.', 'quper' )
			),
		),
		array(
			'id' => 'single_post_layout_position',
			'default' => 'sidebar-right',
			'control' => array(
				'label' => esc_html__( 'Single Post Layout Position', 'quper' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'quper' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'quper' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'quper' ),
				),
				'desc' => esc_html__( 'Specify layout for all single post pages.', 'quper' )
			),
		),
		array(
			'id' => 'single_project_layout_position',
			'default' => 'no-sidebar',
			'control' => array(
				'label' => esc_html__( 'Single Project Layout Position', 'quper' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'quper' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'quper' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'quper' ),
				),
				'desc' => esc_html__( 'Specify layout for all single project pages.', 'quper' ),
				'active_callback' => 'quper_cac_has_single_project',
			),
		),
		array(
			'id' => 'single_service_layout_position',
			'default' => 'no-sidebar',
			'control' => array(
				'label' => esc_html__( 'Single Service Layout Position', 'quper' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'quper' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'quper' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'quper' ),
				),
				'desc' => esc_html__( 'Specify layout for all single service pages.', 'quper' ),
				'active_callback' => 'quper_cac_has_single_service',
			),
		),
	),
);

// Layout Widths
$this->sections['quper_layout_widths'] = array(
	'title' => esc_html__( 'Layout Widths', 'quper' ),
	'panel' => 'quper_layout',
	'settings' => array(
		array(
			'id' => 'site_desktop_container_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Container', 'quper' ),
				'type' => 'text',
				'desc' => esc_html__( 'Default: 1170px', 'quper' ),
			),
			'inline_css' => array(
				'target' => array( 
					'.site-layout-full-width .quper-container',
					'.site-layout-boxed #page'
				),
				'alter' => 'width',
			),
		),
		array(
			'id' => 'left_container_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Content', 'quper' ),
				'type' => 'text',
				'desc' => esc_html__( 'Example: 66%', 'quper' ),
			),
			'inline_css' => array(
				'target' => '#site-content',
				'alter' => 'width',
			),
		),
		array(
			'id' => 'sidebar_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Sidebar', 'quper' ),
				'type' => 'text',
				'desc' => esc_html__( 'Example: 28%', 'quper' ),
			),
			'inline_css' => array(
				'target' => '#sidebar',
				'alter' => 'width',
			),
		),
	),
);