<?php
/**
 * Header setting for Customizer
 *
 * @package quper
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Header General
$this->sections['quper_header_general'] = array(
	'title' => esc_html__( 'General', 'quper' ),
	'panel' => 'quper_header',
	'settings' => array(
		array(
			'id' => 'header_background',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Background', 'quper' ),
				'type' => 'color',
			),
			'inline_css' => array(
				'target' => array(
					'#site-header:after'
				),
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'header_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Padding', 'quper' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'quper' ),
			),
			'inline_css' => array(
				'media_query' => '(min-width: 1199px)',
				'target' => '.site-header-inner',
				'alter' => 'padding',
			),
			'sanitize_callback' => 'esc_url',
		),
		array(
			'id' => 'header_class',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Extra Class', 'quper' ),
				'type' => 'text',
				'desc' => esc_html__( 'Header Class for all pages on website. (e.g. pages, blog posts, single post, archives, etc ). Single page can override this setting in Page Settings metabox when edit.', 'quper' )
			),
		),
	)
);

// Header Logo
$this->sections['quper_header_logo'] = array(
	'title' => esc_html__( 'Logo', 'quper' ),
	'panel' => 'quper_header',
	'settings' => array(
		array(
			'id' => 'custom_logo',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Logo Image', 'quper' ),
				'type' => 'image',
			),
		),
		array(
			'id' => 'logo_width',
			'control' => array(
				'label' => esc_html__( 'Logo Width', 'quper' ),
				'type' => 'text',
			),
		),
	)
);

// Header Menu
$this->sections['quper_header_menu'] = array(
	'title' => esc_html__( 'Menu', 'quper' ),
	'panel' => 'quper_header',
	'settings' => array(
		// General
		array(
			'id' => 'menu_show_current',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Show current page indicator?', 'quper' ),
				'type' => 'checkbox',
			),
		),
		array(
			'id' => 'menu_link_spacing',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Link Spacing', 'quper' ),
				'description' => esc_html__( 'Example: 20px', 'quper' ),
			),
			'inline_css' => array(
				'target' => array(
					'#main-nav > ul > li',
				),
				'alter' => array(
					'padding-left',
					'padding-right',
				),
			),
		),
		array(
			'id' => 'menu_height',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Menu Height', 'quper' ),
				'description' => esc_html__( 'Example: 100px', 'quper' ),
			),
			'inline_css' => array(
				'target' => array(
					'#site-header #main-nav > ul > li > a',
				),
				'alter' => array(
					'height',
					'line-height',
				),
			),
		),
		array(
			'id' => 'menu_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'quper' ),
			),
			'inline_css' => array(
				'target' => array(
					'#main-nav > ul > li > a > span',
				),
				'alter' => 'color',
			),
		),
		array(
			'id' => 'menu_link_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color: Hover', 'quper' ),
			),
			'inline_css' => array(
				'target' => array(
					'#main-nav > ul > li > a:hover > span',
				),
				'alter' => 'color',
			),
		),
	)
);

// Search & Cart
$this->sections['quper_header_search_cart'] = array(
	'title' => esc_html__( 'Search & Cart', 'quper' ),
	'panel' => 'quper_header',
	'settings' => array(
		// Search Icon
		array(
			'id' => 'header_search_icon',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Search Icon', 'quper' ),
				'type' => 'checkbox',
			),
		),
		// Cart Icon
		array(
			'id' => 'header_cart_icon',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Cart Icon', 'quper' ),
				'type' => 'checkbox',
				'active_callback' => 'quper_cac_has_woo',
			),
		),
	)
);

// Button
$this->sections['quper_header_button'] = array(
	'title' => esc_html__( 'Button', 'quper' ),
	'panel' => 'quper_header',
	'settings' => array(
		array(
			'id' => 'header_button_text',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Text', 'quper' ),
				'type' => 'text',
			),
		),
		array(
			'id' => 'header_button_url',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Url', 'quper' ),
				'type' => 'text',
			),
		),
	),
);

// Header Info
$this->sections['quper_header_info'] = array(
	'title' => esc_html__( 'Header Information', 'quper' ),
	'panel' => 'quper_header',
	'settings' => array(
		// Content
		array(
			'id' => 'header_info_phone_prefix',
			'default' => 'Phone:',
			'control' => array(
				'label' => esc_html__( 'Phone', 'quper' ),
				'type' => 'text',
				'rows' => 3,
			),
		),
		array(
			'id' => 'header_info_phone',
			'default' => '',
			'control' => array(
				'type' => 'text',
				'rows' => 3,
			),
		),
		array(
			'id' => 'header_info_email_prefix',
			'default' => 'Email:',
			'control' => array(
				'label' => esc_html__( 'Email', 'quper' ),
				'type' => 'text',
				'rows' => 3,
			),
		),
		array(
			'id' => 'header_info_email',
			'default' => '',
			'control' => array(
				'type' => 'text',
				'rows' => 3,
			),
		),	
		array(
			'id' => 'header_info_address_prefix',
			'default' => 'Address:',
			'control' => array(
				'label' => esc_html__( 'Address', 'quper' ),
				'type' => 'text',
				'rows' => 3,
			),
		),
		array(
			'id' => 'header_info_address',
			'default' => '',
			'control' => array(
				'type' => 'text',
				'rows' => 3,
			),
		),
		// Style
		array(
			'id' => 'header_info_color',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Header Infor Color', 'quper' ),
				'type' => 'color',
			),
			'inline_css' => array(
				'target' => '.header-info .content, #header.header-dark .header-info .content',
				'alter' => 'color',
			),
		),
	),
);

// Top Bar Socials
$this->sections['quper_header_socials'] = array(
	'title' => esc_html__( 'Social', 'quper' ),
	'panel' => 'quper_header',
	'settings' => array(
		array(
			'id' => 'header_socials',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Enable', 'quper' ),
				'type' => 'checkbox',
			),
		),
		array(
			'id' => 'header_socials_spacing',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Socials Spacing', 'quper' ),
				'description' => esc_html__( 'Gap Between Each Social. Example: 10px.', 'quper' ),
				'type' => 'text',
				'active_callback' => 'quper_cac_has_header_socials',
			),
		),
	),
);

// Social settings
$social_options = quper_header_social_options();
foreach ( $social_options as $key => $val ) {
	$this->sections['quper_header_socials']['settings'][] = array(
		'id' => 'header_social_profiles[' . $key .']',
		'control' => array(
			'label' => $val['label'],
			'type' => 'text',
			'active_callback' => 'quper_cac_has_header_socials',
		),
	);
}

// Remove var from memory
unset( $social_options );
