<?php
/**
 * General setting for Customizer
 *
 * @package quper
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Accent Colors
$this->sections['quper_accent_colors'] = array(
	'title' => esc_html__( 'Accent Colors', 'quper' ),
	'panel' => 'quper_general',
	'settings' => array(
		array(
			'id' => 'accent_color',
			'default' => '#f27507',
			'control' => array(
				'label' => esc_html__( 'Accent Color', 'quper' ),
				'type' => 'color',
			),
		),
	)
);

// PreLoader
$this->sections['quper_preloader'] = array(
	'title' => esc_html__( 'PreLoader', 'quper' ),
	'panel' => 'quper_general',
	'settings' => array(
		array(
			'id' => 'preloader',
			'default' => 'animsition',
			'control' => array(
				'label' => esc_html__( 'Preloader Option', 'quper' ),
				'type' => 'select',
				'choices' => array(
					'animsition' => esc_html__( 'Enable','quper' ),
					'' => esc_html__( 'Disable','quper' )
				),
			),
		),
		array(
			'id' => 'preload_color_1',
			'default' => '#f27507',
			'control' => array(
				'label' => esc_html__( 'Color', 'quper' ),
				'type' => 'color',
			),
			'inline_css' => array(
				'target' => '.animsition-loading',
				'alter' => 'background-color',
			),
		),
	)
);

// Header Site
$this->sections['quper_header_site'] = array(
	'title' => esc_html__( 'Header Site', 'quper' ),
	'panel' => 'quper_general',
	'settings' => array(
		array(
			'id' => 'header_site_style',
			'default' => 'style-2',
			'control' => array(
				'label' => esc_html__( 'Header Style', 'quper' ),
				'type' => 'select',
				'choices' => array(
					'style-1' => esc_html__( 'Basic', 'quper' ),
					'style-1 header-float' => esc_html__( 'Basic - Float', 'quper' ),
					'style-2' => esc_html__( 'Full Width', 'quper' ),
					'style-2 header-float' => esc_html__( 'Full Width - Float', 'quper' ),
					'style-3' => esc_html__( 'Modern', 'quper' ),
					'style-4' => esc_html__( 'Aside', 'quper' ),
				),
				'desc' => esc_html__( 'Header Style for all pages on website. (e.g. pages, blog posts, single post, archives, etc ). Single page can override this setting in Page Settings metabox when edit.', 'quper' )
			),
		),
		array(
			'id' => 'header_fixed',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Header Fixed: Enable', 'quper' ),
				'type' => 'checkbox',
			),
		),
	),
);

// Scroll to top
$this->sections['quper_scroll_top'] = array(
	'title' => esc_html__( 'Scroll Top Button', 'quper' ),
	'panel' => 'quper_general',
	'settings' => array(
		array(
			'id' => 'scroll_top',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Enable', 'quper' ),
				'type' => 'checkbox',
			),
		),
	),
);

// Forms
$this->sections['quper_general_forms'] = array(
	'title' => esc_html__( 'Forms', 'quper' ),
	'panel' => 'quper_general',
	'settings' => array(
		array(
			'id' => 'input_border_rounded',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Border Rounded', 'quper' ),
			),
			'inline_css' => array(
				'target' => array(
					'textarea,input[type="text"],input[type="password"],input[type="datetime"],input[type="datetime-local"],input[type="date"],input[type="month"],input[type="time"],input[type="week"],input[type="number"],input[type="email"],input[type="url"],input[type="search"],input[type="tel"],input[type="color"]',
				),
				'alter' => 'border-radius',
			),
		),
		array(
			'id' => 'input_background_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'quper' ),
			),
			'inline_css' => array(
				'target' => array(
					'textarea,input[type="text"],input[type="password"],input[type="datetime"],input[type="datetime-local"],input[type="date"],input[type="month"],input[type="time"],input[type="week"],input[type="number"],input[type="email"],input[type="url"],input[type="search"],input[type="tel"],input[type="color"]',
				),
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'input_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Border Color', 'quper' ),
			),
			'inline_css' => array(
				'target' => array(
					'textarea,input[type="text"],input[type="password"],input[type="datetime"],input[type="datetime-local"],input[type="date"],input[type="month"],input[type="time"],input[type="week"],input[type="number"],input[type="email"],input[type="url"],input[type="search"],input[type="tel"],input[type="color"]',
				),
				'alter' => 'border-color',
			),
		),
		array(
			'id' => 'input_border_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Border Width', 'quper' ),
				'description' => esc_html__( 'Enter a value in pixels. Example: 1px', 'quper' ),
			),
			'inline_css' => array(
				'target' => array(
					'textarea,input[type="text"],input[type="password"],input[type="datetime"],input[type="datetime-local"],input[type="date"],input[type="month"],input[type="time"],input[type="week"],input[type="number"],input[type="email"],input[type="url"],input[type="search"],input[type="tel"],input[type="color"]',
				),
				'alter' => 'border-width',
			),
		),
		array(
			'id' => 'input_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'quper' ),
			),
			'inline_css' => array(
				'target' => array(
					'textarea,input[type="text"],input[type="password"],input[type="datetime"],input[type="datetime-local"],input[type="date"],input[type="month"],input[type="time"],input[type="week"],input[type="number"],input[type="email"],input[type="url"],input[type="search"],input[type="tel"],input[type="color"]',
				),
				'alter' => 'color',
			),
		),
	),
);

// Responsive
$this->sections['quper_responsive'] = array(
	'title' => esc_html__( 'Responsive', 'quper' ),
	'panel' => 'quper_general',
	'settings' => array(
		// Mobile Logo
		array(
			'id' => 'heading_mobile_logo',
			'control' => array(
				'type' => 'quper-heading',
				'label' => esc_html__( 'Mobile Logo', 'quper' ),
			),
		),
		array(
			'id' => 'mobile_logo_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Mobile Logo: Width', 'quper' ),
				'description' => esc_html__( 'Example: 150px', 'quper' ),
			),
			'inline_css' => array(
				'media_query' => '(max-width: 991px)',
				'target' => '#site-logo',
				'alter' => 'max-width',
			),
		),
		array(
			'id' => 'mobile_logo_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Mobile Logo: Margin', 'quper' ),
				'description' => esc_html__( 'Example: 20px 0px 20px 0px', 'quper' ),
			),
			'inline_css' => array(
				'media_query' => '(max-width: 991px)',
				'target' => '#site-logo-inner',
				'alter' => 'margin',
			),
		),
		// Mobile Menu
		array(
			'id' => 'heading_mobile_menu',
			'control' => array(
				'type' => 'quper-heading',
				'label' => esc_html__( 'Mobile Menu', 'quper' ),
			),
		),
		array(
			'id' => 'mobile_menu_item_height',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Item Height', 'quper' ),
				'description' => esc_html__( 'Example: 40px', 'quper' ),
			),
			'inline_css' => array(
				'target' => array(
					'#main-nav-mobi ul > li > a',
					'#main-nav-mobi .menu-item-has-children .arrow'
				),
				'alter' => 'line-height'
			),
		),
		array(
			'id' => 'mobile_menu_logo',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Mobile Menu Logo', 'quper' ),
				'type' => 'image',
			),
		),
		array(
			'id' => 'mobile_menu_logo_width',
			'control' => array(
				'label' => esc_html__( 'Mobile Menu Logo: Width', 'quper' ),
				'type' => 'text',
			),
		),
		// Featured Title
		array(
			'id' => 'heading_featured_title',
			'control' => array(
				'type' => 'quper-heading',
				'label' => esc_html__( 'Mobile Featured Title', 'quper' ),
			),
		),
		array(
			'id' => 'mobile_featured_title_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Padding', 'quper' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'quper' ),
				'active_callback' => 'quper_cac_has_featured_title',
			),
			'inline_css' => array(
				'media_query' => '(max-width: 991px)',
				'target' => '#featured-title .inner-wrap, #featured-title.centered .inner-wrap, #featured-title.creative .inner-wrap',
				'alter' => 'padding',
			),
		),
	)
);