<?php
/**
 * Bottom Bar setting for Customizer
 *
 * @package quper
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Bottom Bar General
$this->sections['quper_bottombar_general'] = array(
	'title' => esc_html__( 'General', 'quper' ),
	'panel' => 'quper_bottombar',
	'settings' => array(
		array(
			'id' => 'bottom_bar',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Enable', 'quper' ),
				'type' => 'checkbox',
			),
		),
		array(
			'id' => 'bottom_bar_style',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Style', 'quper' ),
				'type' => 'select',
				'active_callback' => 'quper_cac_has_bottombar',
				'choices' => array(
					''  	  => esc_html__( 'All Content', 'quper' ),	
					'style-1' => esc_html__( 'Only Copyright', 'quper' ),
					'style-2' => esc_html__( 'Logo + Copyright', 'quper' ),
				),
			),
		),
		array(
			'id' => 'bottom_copyright',
			'transport' => 'postMessage',
			'default' => '&copy; Quper - Construction Multipurpose WordPress Theme.',
			'control' => array(
				'label' => esc_html__( 'Copyright', 'quper' ),
				'type' => 'quper_textarea',
				'active_callback' => 'quper_cac_has_bottombar',
			),
		),
		array(
			'id' => 'bottom_padding',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'text',
				'label' => esc_html__( 'Padding', 'quper' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'quper' ),
				'active_callback'=> 'quper_cac_has_bottombar',
			),
			'inline_css' => array(
				'target' => '#bottom .bottom-bar-inner-wrap',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'bottom_background',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'quper' ),
				'active_callback'=> 'quper_cac_has_bottombar',
			),
			'inline_css' => array(
				'target' => '#bottom',
				'alter' => 'background',
			),
		),
		array(
			'id' => 'bottom_background_img',
			'control' => array(
				'type' => 'image',
				'label' => esc_html__( 'Background Image', 'quper' ),
				'active_callback' => 'quper_cac_has_bottombar',
			),
		),
		array(
			'id' => 'bottom_background_img_style',
			'default' => 'repeat',
			'control' => array(
				'label' => esc_html__( 'Background Image Style', 'quper' ),
				'type'  => 'image',
				'type'  => 'select',
				'choices' => array(
					''             => esc_html__( 'Default', 'quper' ),
					'cover'        => esc_html__( 'Cover', 'quper' ),
					'center-top'        => esc_html__( 'Center Top', 'quper' ),
					'fixed-top'    => esc_html__( 'Fixed Top', 'quper' ),
					'fixed'        => esc_html__( 'Fixed Center', 'quper' ),
					'fixed-bottom' => esc_html__( 'Fixed Bottom', 'quper' ),
					'repeat'       => esc_html__( 'Repeat', 'quper' ),
					'repeat-x'     => esc_html__( 'Repeat-x', 'quper' ),
					'repeat-y'     => esc_html__( 'Repeat-y', 'quper' ),
				),
				'active_callback' => 'quper_cac_has_bottombar',
			),
		),
		array(
			'id' => 'bottom_color',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'quper' ),
				'active_callback'=> 'quper_cac_has_bottombar',
			),
			'inline_css' => array(
				'target' => '#bottom',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'line_color',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'color',
				'label' => esc_html__( 'Line Color', 'quper' ),
				'active_callback'=> 'quper_cac_has_bottombar',
			),
			'inline_css' => array(
				'target' => '#bottom:before',
				'alter' => 'background-color',
			),
		),
	),
);

// Bottom Logo
$this->sections['quper_bottom_logo'] = array(
	'title' => esc_html__( 'Logo', 'quper' ),
	'panel' => 'quper_bottombar',
	'settings' => array(
		array(
			'id' => 'bottom_custom_logo',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Logo Image', 'quper' ),
				'type' => 'image',
			),
		),
		array(
			'id' => 'bottom_logo_width',
			'control' => array(
				'label' => esc_html__( 'Logo Width', 'quper' ),
				'type' => 'text',
			),
		),
	)
);
