<?php
/**
 * Blog setting for Customizer
 *
 * @package quper
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Blog Posts General
$this->sections['quper_blog_post'] = array(
	'title' => esc_html__( 'General', 'quper' ),
	'panel' => 'quper_blog',
	'settings' => array(
		array(
			'id' => 'blog_featured_title',
			'default' => esc_html__( 'Our Blog', 'quper' ),
			'control' => array(
				'label' => esc_html__( 'Blog Featured Title', 'quper' ),
				'type' => 'text',
			),
		),
		array(
			'id' => 'blog_entry_content_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Entry Content Background Color', 'quper' ),
			),
			'inline_css' => array(
				'target' => '.post-content-wrap',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'blog_entry_content_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Entry Content Padding', 'quper' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'quper' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-content-wrap',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'blog_entry_bottom_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Entry Bottom Margin', 'quper' ),
				'description' => esc_html__( 'Example: 30px.', 'quper' ),
			),
			'inline_css' => array(
				'target' => '.hentry',
				'alter' => 'margin-top',
			),
		),
		array(
			'id' => 'blog_entry_border_width',
			'transport' => 'postMessage',
			'control' => array (
				'type' => 'text',
				'label' => esc_html__( 'Entry Border Width', 'quper' ),
				'description' => esc_html__( 'Top Right Bottom Left. Example: 0px 2px 0px 0px', 'quper' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-content-wrap',
				'alter' => 'border-width',
			),
		),
		array(
			'id' => 'blog_entry_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Entry Border Color', 'quper' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-content-wrap',
				'alter' => 'border-color',
			),
		),
		array(
			'id' => 'blog_entry_composer',
			'default' => 'meta,title,excerpt_content,readmore',
			'control' => array(
				'label' => esc_html__( 'Entry Content Elements', 'quper' ),
				'type' => 'quper-sortable',
				'object' => 'Quper_Customize_Control_Sorter',
				'choices' => array(
					'meta'            => esc_html__( 'Meta', 'quper' ),
					'title'           => esc_html__( 'Title', 'quper' ),
					'excerpt_content' => esc_html__( 'Excerpt', 'quper' ),
					'readmore'        => esc_html__( 'Read More', 'quper' ),

				),
				'desc' => esc_html__( 'Drag and drop elements to re-order.', 'quper' ),
			),
		),
	),
);

// Blog Posts Media
$this->sections['quper_blog_post_media'] = array(
	'title' => esc_html__( 'Blog Post - Media', 'quper' ),
	'panel' => 'quper_blog',
	'settings' => array(
		array(
			'id' => 'blog_media_margin_bottom',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Bottom Margin', 'quper' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-media',
				'alter' => 'margin-bottom',
			),
		),
	),
);

// Blog Posts Title
$this->sections['quper_blog_post_title'] = array(
	'title' => esc_html__( 'Blog Post - Title', 'quper' ),
	'panel' => 'quper_blog',
	'settings' => array(
		array(
			'id' => 'blog_title_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Margin', 'quper' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'quper' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-title',
				'alter' => 'margin',
			),
		),
		array(
			'id' => 'blog_title_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'quper' ),
			),
			'inline_css' => array(
				'target' => array(
					'.hentry .post-title a',
				),
				'alter' => 'color',
			),
		),
		array(
			'id' => 'blog_title_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color Hover', 'quper' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-title a:hover',
				'alter' => 'color',
			),
		),
	),
);

// Blog Posts Meta
$this->sections['quper_blog_post_meta'] = array(
	'title' => esc_html__( 'Blog Post - Meta', 'quper' ),
	'panel' => 'quper_blog',
	'settings' => array(
		// Blog Custom Meta
		array(
			'id' => 'blog_custom_meta',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Meta Style', 'quper' ),
				'type' => 'select',
				'choices' => array(
					'style-1' => esc_html__( 'Basic', 'quper' ),
					'style-2' => esc_html__( 'Modern', 'quper' ),
				),
			),
		),
		array(
			'id' => 'blog_before_author',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Text Before Author', 'quper' ),
				'type' => 'text',
			),
		),
		array(
			'id' => 'blog_entry_meta_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Meta Margin', 'quper' ),
				'description' => esc_html__( 'Top Right Bottom Left. Example: 0 0 20px 0.', 'quper' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-meta',
				'alter' => 'margin',
			),
		),
		array(
			'id'  => 'blog_entry_meta_items',
			'default' => array( 'date', 'categories' ),
			'control' => array(
				'label' => esc_html__( 'Meta Items', 'quper' ),
				'desc' => esc_html__( 'Click and drag and drop elements to re-order them.', 'quper' ),
				'type' => 'quper-sortable',
				'object' => 'Quper_Customize_Control_Sorter',
				'choices' => array(
					'author'     => esc_html__( 'Author', 'quper' ),
					'comments' => esc_html__( 'Comments', 'quper' ),
					'date'       => esc_html__( 'Date', 'quper' ),
					'categories' => esc_html__( 'Categories', 'quper' ),
				),
			),
		),
		array(
			'id' => 'heading_blog_entry_meta_item',
			'control' => array(
				'type' => 'quper-heading',
				'label' => esc_html__( 'Item Meta', 'quper' ),
			),
		),
		array(
			'id' => 'blog_entry_meta_item_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Text Color', 'quper' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-meta .item',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'blog_entry_meta_item_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'quper' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-meta .item a',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'blog_entry_meta_item_link_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color Hover', 'quper' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-meta .item a:hover',
				'alter' => 'color',
			),
		),
	),
);

// Blog Posts Excerpt
$this->sections['quper_blog_post_excerpt'] = array(
	'title' => esc_html__( 'Blog Post - Excerpt', 'quper' ),
	'panel' => 'quper_blog',
	'settings' => array(
		array(
			'id' => 'blog_content_style',
			'default' => 'style-1',
			'control' => array(
				'label' => esc_html__( 'Content Style', 'quper' ),
				'type' => 'select',
				'choices' => array(
					'style-1' => esc_html__( 'Normal', 'quper' ),
					'style-2' => esc_html__( 'Excerpt', 'quper' ),
				),
			),
		),
		array(
			'id' => 'blog_excerpt_length',
			'default' => '50',
			'control' => array(
				'label' => esc_html__( 'Excerpt length', 'quper' ),
				'type' => 'text',
				'desc' => esc_html__( 'This option only apply for Content Style: Excerpt.', 'quper' )
			),
		),
		array(
			'id' => 'blog_excerpt_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Margin', 'quper' ),
				'description' => esc_html__( 'Top Right Bottom Left. Example: 0 0 30px 0.', 'quper' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-excerpt',
				'alter' => 'margin',
			),
		),
		array(
			'id' => 'blog_excerpt_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'quper' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-excerpt',
				'alter' => 'color',
			),
		),
	),
);

// Blog Posts Read More
$this->sections['quper_blog_post_read_more'] = array(
	'title' => esc_html__( 'Blog Post - Read More', 'quper' ),
	'panel' => 'quper_blog',
	'settings' => array(
		array(
			'id' => 'blog_entry_button_read_more_text',
			'default' => esc_html__( 'Read More', 'quper' ),
			'control' => array(
				'label' => esc_html__( 'Button Text', 'quper' ),
				'type' => 'text',
			),
		),
	),
);

