<?php
/*
Widget Name: Testimonial Slider
Comment: 
Author: Masterlayer
Author URI: http://masterlayer.edu.vn
Plugin URI: https://masterlayer.edu.vn/masterlayer-addons-for-masterlayer/
*/

namespace MasterlayerAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Icons_Manager;
use Elementor\Core\Schemes\Color;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use Elementor\Modules\DynamicTags\Module as TagsModule;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class MAE_Testimonial_Slider_Widget extends Widget_Base {

    public function __construct($data = [], $args = null) {
        parent::__construct($data, $args);
    }

    public function get_script_depends() {
        return [ 'slick' ];
    }

    public function get_style_depends() {
        return [ 'slick' ];
    }

    // The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
    public function get_name() {
        return 'mae-testimonial-slider';
    }

    // The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
    public function get_title() {
        return __( 'Testimonial Slider', 'masterlayer' );
    }

    // The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
    public function get_icon() {
        return 'eicon-media-carousel';
    }

    // The get_categories method, lets you set the category of the widget, return the category name as a string.
    public function get_categories() {
        return [ 'masterlayer-addons' ];
    } 

    protected function register_controls() {

        // Content Section
        $this->start_controls_section( 'content_section',
            [
                'label' => __( 'Content', 'masterlayer' ),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'avatar',
            [
                'label'   => __( 'Avatar', 'masterlayer' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [ 'url' => Utils::get_placeholder_image_src(), ]
            ],
        );

        $repeater->add_control(
            'name',
            [
                'label'   => __( 'Name', 'masterlayer' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __( 'New Member', 'masterlayer' ),
            ]
        );

        $repeater->add_control(
            'position',
            [
                'label'   => __( 'Position', 'masterlayer' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __( 'Manager', 'masterlayer' ),
            ]
        );

        $repeater->add_control(
            'comment',
            [
                'label'      => __( 'Comment', 'masterlayer' ),
                'type'       => Controls_Manager::WYSIWYG,
                'default'    => __( 'Rump spare ribs tail pastrami ham hock turducken fatback salami. Ham hock tenderloin drumstick pork belly.', 'masterlayer' ),
            ]
        );

        $this->add_control(
            'testimonials',
            [
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default'     => [
                    [
                        'name'  => __( 'Client #1', 'masterlayer' ),
                    ],
                    [
                        'name'  => __( 'Client #2', 'masterlayer' ),
                    ],
                    [
                        'name'  => __( 'Client #3', 'masterlayer' ),
                    ],
                ],
                'title_field' => '{{{ name }}}',
            ]
        );

        $this->end_controls_section();

        // Settings TAB
        $this->start_controls_section( 'setting_general_section',
            [
                'label' => __( 'General', 'masterlayer' ),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __( 'Alignment', 'masterlayer' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'masterlayer' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'masterlayer' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'masterlayer' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'prefix_class' => 'align-',
            ]
        );

        $this->add_control(
            'style',
            [
                'label'     => __( 'Style', 'masterlayer'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'style-1',
                'options'   => [
                    'style-1'      => __( 'Style 1', 'masterlayer'),
                    'style-2'      => __( 'Style 2', 'masterlayer'),
                ],
                'prefix_class' => 'testimonials-'
            ]
        );

        $this->add_responsive_control(
            'nav_number',
            [
                'label'     => __( 'Navigation Numbers', 'masterlayer'),
                'type'      => Controls_Manager::NUMBER,
                'default'   => 1,
                'min'     => 1,
                'max'     => 3,
                'step'    => 1
            ]
        );

        $this->add_control(
            'show_arrow',
            [
                'label'        => __( 'Show Arrows', 'masterlayer' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'On', 'masterlayer' ),
                'label_off'    => __( 'Off', 'masterlayer' ),
                'return_value' => 'true',
                'default'      => 'false',
            ]
        );

        $this->add_control(
            'arrow_pos',
            [
                'label'     => __( 'Arrow Position', 'masterlayer'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'middle',
                'options'   => [
                    'middle'      => __( 'Middle', 'masterlayer'),
                    'bottom'      => __( 'Bottom', 'masterlayer'),
                ]
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label'        => __( 'Autoplay', 'masterlayer' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'On', 'masterlayer' ),
                'label_off'    => __( 'Off', 'masterlayer' ),
                'return_value' => 'true',
                'default'      => 'false',
            ]
        );

        $this->end_controls_section();

        // STYLE TAB
        // General
        $this->start_controls_section( 'style_general_section',
            [
                'label' => __( 'General', 'masterlayer' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( 'box' );

        $this->start_controls_tab(
            'box_normal',
            [
                'label' => __( 'Normal', 'masterlayer' ),
            ]
        );

        $this->add_control(
            'color_heading',
            [
                'label' => __( 'Color', 'masterlayer' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after'
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label' => __( 'Name', 'masterlayer' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .master-testimonial-slider .name' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'position_color',
            [
                'label' => __( 'Position', 'masterlayer' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .master-testimonial-slider .position' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'desc_color',
            [
                'label' => __( 'Comment', 'masterlayer' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .master-testimonial-slider .content-wrap .comment' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'bg_heading',
            [
                'label' => __( 'Background', 'masterlayer' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after'
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'box_bg',
                'label' => __( 'Background', 'masterlayer' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .master-testimonial-slider .content-wrap',
            ]
        );

        $this->add_control(
            'border_heading',
            [
                'label' => __( 'Border', 'masterlayer' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after'
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'label' => __( 'Border', 'masterlayer' ),
                'selector' => '{{WRAPPER}} .master-testimonial-slider .content-wrap',
            ]
        );

        $this->add_control(
            'rounded_heading',
            [
                'label' => __( 'Rounded', 'masterlayer' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after'
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => __('Rounded', 'masterlayer'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .master-testimonial-slider .content-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'shadow_heading',
            [
                'label' => __( 'Box Shadow', 'masterlayer' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after'
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .master-testimonial-slider .content-wrap',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'testimonial_box_hover',
            [
                'label' => __( 'Hover', 'masterlayer' ),
            ]
        );

        $this->add_control(
            'color_heading_hover',
            [
                'label' => __( 'Color', 'masterlayer' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after'
            ]
        );

        $this->add_control(
            'name_color_hover',
            [
                'label' => __( 'Name', 'masterlayer' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .master-testimonial-slider .name:hover' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'position_color_hover',
            [
                'label' => __( 'Position', 'masterlayer' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .master-testimonial-slider .position:hover' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'desc_color_hover',
            [
                'label' => __( 'Comment', 'masterlayer' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .master-testimonial-slider .content-wrap:hover .comment' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'bg_heading_hover',
            [
                'label' => __( 'Background', 'masterlayer' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after'
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'box_bg_hover',
                'label' => __( 'Background', 'masterlayer' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .master-testimonial-slider .content-wrap:hover',
            ]
        );

        $this->add_control(
            'border_heading_hover',
            [
                'label' => __( 'Border', 'masterlayer' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after'
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border_hover',
                'label' => __( 'Border', 'masterlayer' ),
                'selector' => '{{WRAPPER}} .master-testimonial-slider .content-wrap:hover',
            ]
        );

        $this->add_control(
            'rounded_heading_hover',
            [
                'label' => __( 'Rounded', 'masterlayer' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after'
            ]
        );

        $this->add_control(
            'border_radius_hover',
            [
                'label' => __('Rounded', 'masterlayer'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .master-testimonial-slider .content-wrap:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'shadow_heading_hover',
            [
                'label' => __( 'Box Shadow', 'masterlayer' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after'
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow_hover',
                'selector' => '{{WRAPPER}} .master-testimonial-slider .content-wrap:hover',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        // Spacing
        $this->start_controls_section( 'setting_spacing_section',
            [
                'label' => __( 'Spacing', 'masterlayer' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'slider_content_margin',
            [
                'label' => __('Slide Content Margin', 'masterlayer'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'default' => [
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .master-testimonial-slider .slick-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'margin',
            [
                'label' => __('Content Margin', 'masterlayer'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'default' => [
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .master-testimonial-slider .content-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label' => __('Content Padding', 'masterlayer'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'default' => [
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .master-testimonial-slider .content-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Typography
        $this->start_controls_section( 'setting_typography_section',
            [
                'label' => __( 'Typography', 'masterlayer' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'name_typography',
                'label' => __('Name', 'masterlayer'),
                'selector' => '{{WRAPPER}} .name'
            ],
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'position_typography',
                'label' => __('Position', 'masterlayer'),
                'selector' => '{{WRAPPER}} .position'
            ],
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'comment_typography',
                'label' => __('Comment', 'masterlayer'),
                'selector' => '{{WRAPPER}} .comment'
            ],
        );

        $this->end_controls_section();
    }

    protected function render() {
        $nav_config = array();
        $content_config = array();
        $cls = $css = $data_nav = $data_content = "";
        $settings = $this->get_settings_for_display();
        $testimonials = $this->get_settings_for_display( 'testimonials' );
        $slidesToShow = $slidesToShow_tablet = $slidesToShow_mobile = 1;

        if ($settings['nav_number']) $slidesToShow = $settings['nav_number'];
        $settings['nav_number_tablet']
            ? $slidesToShow_tablet = $settings['nav_number_tablet']
            : $slidesToShow_tablet = $slidesToShow;
        $settings['nav_number_mobile']
            ? $slidesToShow_mobile = $settings['nav_number_mobile']
            : $slidesToShow_mobile = $slidesToShow_tablet;

        // Data       
        $nav_config['centerMode'] = true;
        $nav_config['infinite'] = true;
        $nav_config['focusOnSelect'] = true;
        $nav_config['centerPadding'] = 0;
        $nav_config['slidesToShow'] = $slidesToShow;
        $nav_config['slidesToScroll'] = 1;
        $nav_config['arrows'] = false;
        if ( ($settings['show_arrow'] == 'true') && ($settings['arrow_pos'] == 'bottom') )
            $nav_config['arrows'] = true;

        $nav_config['responsive'][0]['breakpoint'] = 1200; 
        $nav_config['responsive'][0]['settings']['slidesToShow'] = $slidesToShow; 
        $nav_config['responsive'][0]['settings']['slidesToScroll'] = 1; 
        $nav_config['responsive'][0]['settings']['centerMode'] = true;

        $nav_config['responsive'][1]['breakpoint'] = 1025; 
        $nav_config['responsive'][1]['settings']['slidesToShow'] = $slidesToShow_tablet;
        $nav_config['responsive'][1]['settings']['slidesToScroll'] = 1; 
        $nav_config['responsive'][1]['settings']['centerMode'] = true; 
        $nav_config['responsive'][1]['settings']['vertical'] = false;         
        $nav_config['responsive'][1]['settings']['verticalSwiping'] = false;         

        $nav_config['responsive'][2]['breakpoint'] = 767; 
        $nav_config['responsive'][2]['settings']['slidesToShow'] = $slidesToShow_mobile; 
        $nav_config['responsive'][2]['settings']['slidesToScroll'] = 1; 
        $nav_config['responsive'][2]['settings']['centerMode'] = true; 
        $nav_config['responsive'][2]['settings']['vertical'] = false;         
        $nav_config['responsive'][2]['settings']['verticalSwiping'] = false; 

        if ( $settings['style'] == 'style-2' ) {
            $nav_config['slidesToShow'] = 3;
            //$nav_config['centerPadding'] = '170px';
            $nav_config['infinite'] = true;
        }  

        $data_nav = 'data-slick=\'' . json_encode( $nav_config ) . '\'';
        
        $content_config['arrows'] = false;
        if ( ($settings['show_arrow'] == 'true') && ($settings['arrow_pos'] == 'middle') )
            $content_config['arrows'] = true;
        $content_config['dots'] = false;
        $content_config['infinite'] = true;
        
        if ( $settings['autoplay'] == 'true' ) {
            $content_config['autoplay'] = true;
            $content_config['autoplaySpeed'] = 3000;
        }

        $data_content = 'data-slick=\'' . json_encode( $content_config ) . '\'';
        ?>

        <div class="master-slick-slider master-testimonial-slider">
            <div class="slick-container slick-content">
                <div class="slick-slider" data-nav-target="#carousel-quotes-nav" id="carousel-quotes" <?php echo $data_content; ?>>
                    <?php
                    foreach ( $testimonials as $index => $item ) { 
                        $html = $comment = "";

                        // Comment
                        if ($item['comment'])
                            $comment = sprintf('<div class="comment">%1$s</div>', 
                                $item['comment'] );

                        echo '<div><div class="content-wrap">';
                        echo $comment;
                        echo '</div></div>';

                    } ?>
                </div>
            </div> 

            <div class="slick-container slick-nav">
                <div class="slick-slider-nav" id="carousel-quotes-nav" data-nav-target="#carousel-quotes" <?php echo $data_nav; ?>>
                    <?php
                    foreach ( $testimonials as $index => $item ) { 
                        $html = $name = $position = $avatar = "";
                        
                        // Name
                        if ($item['name'])
                            $name = sprintf('<h3 class="name">%1$s</h3>', 
                                esc_html( $item['name'] ) );

                        // Position
                        if ($item['position'])
                            $position = sprintf('<div class="position">%1$s</div>', 
                                esc_html( $item['position'] ) );

                        // Avatar 
                        if ($item['avatar'])
                            $avatar = sprintf('<div class="avatar"><img alt="Avatar" src="%1$s" /></div>', $item['avatar']['url']);
                        ?>
                        <div class="slick-nav-item">
                            <div class="author-wrap">
                                <?php echo $avatar; ?>
                                <div class="info-wrap">
                                    <?php
                                    echo $name;
                                    echo $position;
                                    ?>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>  
        </div>

        <?php
    } 

    protected function content_template() {}
}

