<?php

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly


add_filter( 'elementor/icons_manager/additional_tabs', 'mae_iconpicker_register' );

function mae_iconpicker_register( $icons = array() ) {

	$icons['quper'] = array(
		'name'          => 'quper',
		'label'         => esc_html__( 'Quper Icons', 'masterlayer' ),
		'labelIcon'     => 'qico-helmet',
		'prefix'        => 'qico-',
		'displayPrefix' => '',
		'url'           => MAE_URL . 'assets/css/quper-icons.css',
		'fetchJson'     => MAE_URL . 'assets/fonts/quper-icons/quper-icons.json',
		'ver'           => '1.0.0',
	);

	$icons['arts'] = array(
		'name'          => 'art',
		'label'         => esc_html__( 'General Arts Icons', 'masterlayer' ),
		'labelIcon'     => 'aicon-picture',
		'prefix'        => 'aicon-',
		'displayPrefix' => '',
		'url'           => MAE_URL . 'assets/css/arts-icons.css',
		'fetchJson'     => MAE_URL . 'assets/fonts/arts-icons/arts-icons.json',
		'ver'           => '1.0.0',
	);

	$icons['construction'] = array(
		'name'          => 'construction',
		'label'         => esc_html__( 'Construction Icons', 'masterlayer' ),
		'labelIcon'     => 'cicon-barrier',
		'prefix'        => 'cicon-',
		'displayPrefix' => '',
		'url'           => MAE_URL . 'assets/css/construction-icons.css',
		'fetchJson'     => MAE_URL . 'assets/fonts/construction-icons/construction-icons.json',
		'ver'           => '1.0.0',
	);

	$icons['construction2'] = array(
		'name'          => 'construction2',
		'label'         => esc_html__( 'Construction Icons 2', 'masterlayer' ),
		'labelIcon'     => 'c2icon-001-helmet',
		'prefix'        => 'c2icon-',
		'displayPrefix' => '',
		'url'           => MAE_URL . 'assets/css/construction2-icons.css',
		'fetchJson'     => MAE_URL . 'assets/fonts/construction2-icons/construction2-icons.json',
		'ver'           => '1.0.0',
	);

	$icons['socials'] = array(
		'name'          => 'socials',
		'label'         => esc_html__( 'Socials Icons', 'masterlayer' ),
		'labelIcon'     => 'sicon-001-cloud-computing',
		'prefix'        => 'sicon-',
		'displayPrefix' => '',
		'url'           => MAE_URL . 'assets/css/socials-icons.css',
		'fetchJson'     => MAE_URL . 'assets/fonts/socials-icons/socials-icons.json',
		'ver'           => '1.0.0',
	);

	$icons['feather'] = array(
		'name'          => 'feather',
		'label'         => esc_html__( 'Feather Icons', 'masterlayer' ),
		'labelIcon'     => 'fe-feather',
		'prefix'        => 'fe-',
		'displayPrefix' => '',
		'url'           => MAE_URL . 'assets/css/feather-icons.css',
		'fetchJson'     => MAE_URL . 'assets/fonts/feather-icons/feather.json',
		'ver'           => '1.0.0',
	);

	return $icons;
}
